import { a as useNuxtApp, s as script, _ as _export_sfc } from "../server.mjs";
import { ref, resolveComponent, unref, withCtx, createTextVNode, createVNode, useSSRContext, computed, mergeProps, openBlock, createBlock, Fragment, renderList, toDisplayString, createCommentVNode, withModifiers, watch, renderSlot } from "vue";
import "destr";
import "devalue";
import "klona";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrRenderAttr, ssrRenderClass, ssrRenderSlot } from "vue/server-renderer";
import { u as useAuthStore } from "./auth-6d0727c5.js";
import { _ as __nuxt_component_0$1, a as __nuxt_component_1$1 } from "./SectionContainer-5a7aa7e3.js";
import { _ as __nuxt_component_3$1 } from "./Icon-7157bd57.js";
import "hookable";
import { _ as __nuxt_component_5$1 } from "./FormField-14acbd69.js";
import { _ as __nuxt_component_8 } from "./RoundedButton-a0ea68b9.js";
import _ from "lodash";
import { u as useDayjs } from "./dayjs-9d0b29d3.js";
import { C as CitySelectField } from "./CitySelectField-385f4d0e.js";
import { s as script$1 } from "./fileupload.esm-d9f386d4.js";
import { _ as __nuxt_component_0$2 } from "./nuxt-link-801c5f56.js";
import "ofetch";
import "#internal/nitro";
import "unctx";
import "vue-router";
import "h3";
import "ufo";
import "@vue/devtools-api";
import "@unhead/ssr";
import "unhead";
import "@unhead/shared";
import "dayjs";
import "dayjs/locale/fr.js";
import "dayjs/plugin/relativeTime.js";
import "dayjs/plugin/utc.js";
import "dayjs/plugin/timezone.js";
import "@headlessui/vue";
import "vue-i18n";
import "vue3-popper";
import "defu";
const _sfc_main$b = {
  __name: "AccountMessages",
  __ssrInlineRender: true,
  setup(__props) {
    const authStore = useAuthStore();
    const company = authStore.company;
    const { $event, $api } = useNuxtApp();
    ref(false);
    const openMobileModal = () => {
      $event("open-mobile-modal");
    };
    const openOnboardingStripe = () => {
      $event("open-onboarding-stripe");
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Message = resolveComponent("Message");
      const _component_Button = resolveComponent("Button");
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      if (!unref(company).activated) {
        _push(ssrRenderComponent(_component_Message, {
          severity: "warn",
          closable: false
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(` Votre compte est en attente de vérification par notre équipe.<br${_scopeId}> vous allez être recontacté par nos équipes pour obtenir d&#39;avantage d&#39;informations sur votre entreprise.<br${_scopeId}> Cette formalité est nécessaire pour être en conformité avec la réglementation <a class="underline" target="_blank" href="https://support.stripe.com/questions/know-your-customer-obligations"${_scopeId}>KYC (Know Your Client).</a>. <br${_scopeId}> Une fois votre compte vérifié, vous pourrez accéder à toutes les fonctionnalités de votre compte. `);
            } else {
              return [
                createTextVNode(" Votre compte est en attente de vérification par notre équipe."),
                createVNode("br"),
                createTextVNode(" vous allez être recontacté par nos équipes pour obtenir d'avantage d'informations sur votre entreprise."),
                createVNode("br"),
                createTextVNode(" Cette formalité est nécessaire pour être en conformité avec la réglementation "),
                createVNode("a", {
                  class: "underline",
                  target: "_blank",
                  href: "https://support.stripe.com/questions/know-your-customer-obligations"
                }, "KYC (Know Your Client)."),
                createTextVNode(". "),
                createVNode("br"),
                createTextVNode(" Une fois votre compte vérifié, vous pourrez accéder à toutes les fonctionnalités de votre compte. ")
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      if (!unref(company).onboarding_completed) {
        _push(ssrRenderComponent(_component_Message, {
          severity: "warn",
          closable: false
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="flex w-full gap-5"${_scopeId}><div class="w-1/2"${_scopeId}> Afin de pouvoir recevoir des paiements des autres utilisateurs de la plateforme, nous vous invitons à compléter votre profil Stripe. </div>`);
              _push2(ssrRenderComponent(_component_Button, {
                onClick: openOnboardingStripe,
                label: "Compléter mon profil Stripe",
                outlined: "",
                class: "w-1/2",
                severity: "warning"
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "flex w-full gap-5" }, [
                  createVNode("div", { class: "w-1/2" }, " Afin de pouvoir recevoir des paiements des autres utilisateurs de la plateforme, nous vous invitons à compléter votre profil Stripe. "),
                  createVNode(_component_Button, {
                    onClick: openOnboardingStripe,
                    label: "Compléter mon profil Stripe",
                    outlined: "",
                    class: "w-1/2",
                    severity: "warning"
                  })
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      if (!unref(company).mobile_verified_at) {
        _push(ssrRenderComponent(_component_Message, {
          severity: "warn",
          closable: false
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="flex w-full items-center"${_scopeId}><div class="w-1/2"${_scopeId}> Afin d&#39;assurer la sécurité de votre compte, nous vous invitons à procéder à la vérification de votre numéro de téléphone. </div>`);
              _push2(ssrRenderComponent(_component_Button, {
                onClick: openMobileModal,
                label: "Vérifier mon numéro",
                outlined: "",
                class: "w-1/2",
                severity: "warning"
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "flex w-full items-center" }, [
                  createVNode("div", { class: "w-1/2" }, " Afin d'assurer la sécurité de votre compte, nous vous invitons à procéder à la vérification de votre numéro de téléphone. "),
                  createVNode(_component_Button, {
                    onClick: openMobileModal,
                    label: "Vérifier mon numéro",
                    outlined: "",
                    class: "w-1/2",
                    severity: "warning"
                  })
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      if (!unref(company).has_valid_clearance) {
        _push(ssrRenderComponent(_component_Message, {
          severity: "error",
          closable: false
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(` Votre habilitation n&#39;est plus valide. veuillez la renouveler pour continuer à utiliser la plateforme. pour cela, veuillez charger votre nouvelle habilitation dans la section &quot;Pièces justificatives&quot; ci-dessous et mettre à jour la nouvelle date de validité. `);
            } else {
              return [
                createTextVNode(` Votre habilitation n'est plus valide. veuillez la renouveler pour continuer à utiliser la plateforme. pour cela, veuillez charger votre nouvelle habilitation dans la section "Pièces justificatives" ci-dessous et mettre à jour la nouvelle date de validité. `)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      if (unref(company).clearance_need_verification) {
        _push(ssrRenderComponent(_component_Message, {
          severity: "warn",
          closable: false
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(` Votre habilitation est en attente de vérification par notre équipe. Vous serez notifié par email dès que votre habilitation sera validée. `);
            } else {
              return [
                createTextVNode(" Votre habilitation est en attente de vérification par notre équipe. Vous serez notifié par email dès que votre habilitation sera validée. ")
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup$b = _sfc_main$b.setup;
_sfc_main$b.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/AccountMessages.vue");
  return _sfc_setup$b ? _sfc_setup$b(props, ctx) : void 0;
};
const __nuxt_component_0 = _sfc_main$b;
const _sfc_main$a = {
  __name: "Statistics",
  __ssrInlineRender: true,
  setup(__props) {
    const stats = ref({});
    const loading = ref(false);
    const computedStats = computed(() => {
      var _a, _b, _c, _d;
      return [
        {
          icon: "pin-2",
          title: "Trajets disponibles sur la plateforme",
          count: ((_a = stats.value) == null ? void 0 : _a.total_available_routes) ?? 0
        },
        {
          icon: "pin-2",
          title: "Total des trajets proposés sur la plateforme",
          count: ((_b = stats.value) == null ? void 0 : _b.total_created_routes) ?? 0
        },
        {
          icon: "pin-2",
          title: "Mes trajets en ligne",
          count: ((_c = stats.value) == null ? void 0 : _c.company_available_routes) ?? 0
        },
        {
          icon: "pin-2",
          title: "Mes trajets effectués",
          count: ((_d = stats.value) == null ? void 0 : _d.company_finished_route) ?? 0
        }
      ];
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_wrapper = __nuxt_component_0$1;
      const _component_section_container = __nuxt_component_1$1;
      const _component_Skeleton = resolveComponent("Skeleton");
      const _component_icon = __nuxt_component_3$1;
      _push(ssrRenderComponent(_component_section_wrapper, mergeProps({ class: "bg-background-3" }, _attrs), {
        default: withCtx((_2, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container pb-8 pt-8 max-xl:text-center max-md:hidden"
            }, {
              default: withCtx((_3, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  if (unref(loading)) {
                    _push3(`<div class="grid-cols-4 gap-5 max-lg:grid-cols-2 md:grid"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_Skeleton, {
                      height: "13rem",
                      class: "w-full",
                      borderRadius: "16px"
                    }, null, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_Skeleton, {
                      height: "13rem",
                      class: "w-full",
                      borderRadius: "16px"
                    }, null, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_Skeleton, {
                      height: "13rem",
                      class: "w-full",
                      borderRadius: "16px"
                    }, null, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_Skeleton, {
                      height: "13rem",
                      class: "w-full",
                      borderRadius: "16px"
                    }, null, _parent3, _scopeId2));
                    _push3(`</div>`);
                  } else {
                    _push3(`<div class="grid-cols-4 gap-5 max-lg:grid-cols-2 md:grid"${_scopeId2}><!--[-->`);
                    ssrRenderList(unref(computedStats), (stat, index) => {
                      _push3(`<div class="flex bg-white max-md:items-center max-md:gap-3 max-md:p-3 md:flex-col md:p-8"${_scopeId2}>`);
                      _push3(ssrRenderComponent(_component_icon, {
                        class: "text-secondary mb-6 h-8 w-8",
                        icon: stat.icon
                      }, null, _parent3, _scopeId2));
                      _push3(`<div class="text-primary mb-2 text-[1.875rem] font-semibold"${_scopeId2}>${ssrInterpolate(stat.count)}</div><div class="text-[#707070]"${_scopeId2}>${ssrInterpolate(stat.title)}</div></div>`);
                    });
                    _push3(`<!--]--></div>`);
                  }
                } else {
                  return [
                    unref(loading) ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "grid-cols-4 gap-5 max-lg:grid-cols-2 md:grid"
                    }, [
                      createVNode(_component_Skeleton, {
                        height: "13rem",
                        class: "w-full",
                        borderRadius: "16px"
                      }),
                      createVNode(_component_Skeleton, {
                        height: "13rem",
                        class: "w-full",
                        borderRadius: "16px"
                      }),
                      createVNode(_component_Skeleton, {
                        height: "13rem",
                        class: "w-full",
                        borderRadius: "16px"
                      }),
                      createVNode(_component_Skeleton, {
                        height: "13rem",
                        class: "w-full",
                        borderRadius: "16px"
                      })
                    ])) : (openBlock(), createBlock("div", {
                      key: 1,
                      class: "grid-cols-4 gap-5 max-lg:grid-cols-2 md:grid"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(computedStats), (stat, index) => {
                        return openBlock(), createBlock("div", {
                          key: index,
                          class: "flex bg-white max-md:items-center max-md:gap-3 max-md:p-3 md:flex-col md:p-8"
                        }, [
                          createVNode(_component_icon, {
                            class: "text-secondary mb-6 h-8 w-8",
                            icon: stat.icon
                          }, null, 8, ["icon"]),
                          createVNode("div", { class: "text-primary mb-2 text-[1.875rem] font-semibold" }, toDisplayString(stat.count), 1),
                          createVNode("div", { class: "text-[#707070]" }, toDisplayString(stat.title), 1)
                        ]);
                      }), 128))
                    ]))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container pb-8 pt-8 max-xl:text-center max-md:hidden"
              }, {
                default: withCtx(() => [
                  unref(loading) ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "grid-cols-4 gap-5 max-lg:grid-cols-2 md:grid"
                  }, [
                    createVNode(_component_Skeleton, {
                      height: "13rem",
                      class: "w-full",
                      borderRadius: "16px"
                    }),
                    createVNode(_component_Skeleton, {
                      height: "13rem",
                      class: "w-full",
                      borderRadius: "16px"
                    }),
                    createVNode(_component_Skeleton, {
                      height: "13rem",
                      class: "w-full",
                      borderRadius: "16px"
                    }),
                    createVNode(_component_Skeleton, {
                      height: "13rem",
                      class: "w-full",
                      borderRadius: "16px"
                    })
                  ])) : (openBlock(), createBlock("div", {
                    key: 1,
                    class: "grid-cols-4 gap-5 max-lg:grid-cols-2 md:grid"
                  }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(computedStats), (stat, index) => {
                      return openBlock(), createBlock("div", {
                        key: index,
                        class: "flex bg-white max-md:items-center max-md:gap-3 max-md:p-3 md:flex-col md:p-8"
                      }, [
                        createVNode(_component_icon, {
                          class: "text-secondary mb-6 h-8 w-8",
                          icon: stat.icon
                        }, null, 8, ["icon"]),
                        createVNode("div", { class: "text-primary mb-2 text-[1.875rem] font-semibold" }, toDisplayString(stat.count), 1),
                        createVNode("div", { class: "text-[#707070]" }, toDisplayString(stat.title), 1)
                      ]);
                    }), 128))
                  ]))
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$a = _sfc_main$a.setup;
_sfc_main$a.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/Statistics.vue");
  return _sfc_setup$a ? _sfc_setup$a(props, ctx) : void 0;
};
const __nuxt_component_1 = _sfc_main$a;
function convertToSuccess(toastId, message) {
  const { $toast } = useNuxtApp();
  $toast.update(toastId, {
    type: "success",
    render: message,
    isLoading: false,
    closeButton: true,
    closeOnClick: true,
    autoClose: true,
    timeout: 3e3
  });
}
function convertToError(toastId, message) {
  const { $toast } = useNuxtApp();
  $toast.update(toastId, {
    type: "error",
    render: message,
    isLoading: false,
    closeButton: true,
    closeOnClick: true,
    autoClose: true,
    timeout: 3e3
  });
}
const errorHandler = (err, errorRef = null, validationErrorsRef = null, toastId = null) => {
  const { $toast } = useNuxtApp();
  if (err.response) {
    if (err.response.status === 422) {
      let message = "Un ou plusieurs champs sont invalides";
      if (err.response.data.message) {
        message = err.response.data.message;
      } else if (err.response.data.error) {
        message = err.response.data.error;
      }
      if (errorRef) {
        errorRef.value = message;
      }
      if (validationErrorsRef) {
        validationErrorsRef.value = err.response.data.errors;
      }
      if (toastId) {
        convertToError(toastId, message);
      } else {
        $toast.error(message);
      }
    } else {
      const message = err.response.data.message || err.response.data.error || err || "Une erreur est survenue";
      console.error(err);
      if (errorRef) {
        errorRef.value = message;
      }
      if (toastId) {
        convertToError(toastId, message);
      } else {
        $toast.error(message);
      }
    }
  } else {
    if (toastId) {
      convertToError(toastId, err || "Une erreur est survenue");
    } else {
      $toast.error(err || "Une erreur est survenue");
    }
    if (errorRef) {
      errorRef.value = err || "Une erreur est survenue";
    }
    console.error(err);
  }
};
const useUtils = () => {
  return {
    convertToSuccess,
    convertToError,
    errorHandler
  };
};
const _sfc_main$9 = {
  __name: "MeForm",
  __ssrInlineRender: true,
  setup(__props) {
    const { convertToSuccess: convertToSuccess2, errorHandler: errorHandler2 } = useUtils();
    const authStore = useAuthStore();
    const meData = ref(null);
    const loading = ref(false);
    const fetching = ref(false);
    const success = ref(null);
    const error2 = ref(null);
    const validationErrors = ref({});
    const { $toast, $listen, $unListen } = useNuxtApp();
    const update = async () => {
      loading.value = true;
      error2.value = null;
      success.value = null;
      validationErrors.value = {};
      const toastId = $toast.loading("Mise à jour en cours...");
      try {
        const me = await authStore.updateMe(meData.value);
        meData.value = me;
        convertToSuccess2(toastId, "Vos informations ont été mises à jour");
        success.value = "Vos informations ont été mises à jour";
      } catch (e) {
        errorHandler2(e, error2, validationErrors, toastId);
      } finally {
        loading.value = false;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_wrapper = __nuxt_component_0$1;
      const _component_section_container = __nuxt_component_1$1;
      const _component_ProgressBar = resolveComponent("ProgressBar");
      const _component_Message = resolveComponent("Message");
      const _component_FormField = __nuxt_component_5$1;
      const _component_InputText = resolveComponent("InputText");
      const _component_rounded_button = __nuxt_component_8;
      const _component_ProgressSpinner = resolveComponent("ProgressSpinner");
      _push(ssrRenderComponent(_component_section_wrapper, mergeProps({ class: "bg-background-3 pb-12" }, _attrs), {
        default: withCtx((_2, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container"
            }, {
              default: withCtx((_3, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="rounded-xl bg-white px-12 py-8"${_scopeId2}><h2 class="text-primary mb-10 text-[1.563rem] font-bold"${_scopeId2}> Mes informations personnelles </h2>`);
                  if (fetching.value) {
                    _push3(ssrRenderComponent(_component_ProgressBar, {
                      mode: "indeterminate",
                      class: "mb-10",
                      style: { "height": "6px" }
                    }, null, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (error2.value) {
                    _push3(ssrRenderComponent(_component_Message, { severity: "error" }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(error2.value)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(error2.value), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (success.value) {
                    _push3(ssrRenderComponent(_component_Message, {
                      sticky: false,
                      life: "3000",
                      severity: "success"
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(success.value)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(success.value), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (meData.value) {
                    _push3(`<form${_scopeId2}><div class="grid-cols-2 gap-x-10 md:grid"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "firstname",
                      label: "Prénom",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-pencil"${_scopeId3}></i>`);
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: meData.value.firstname,
                            "onUpdate:modelValue": ($event) => meData.value.firstname = $event,
                            type: "text",
                            placeholder: "Votre prénom",
                            class: `w-full ${validationErrors.value.firstname ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, _parent4, _scopeId3));
                          _push4(`</div>`);
                        } else {
                          return [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(_component_InputText, {
                                modelValue: meData.value.firstname,
                                "onUpdate:modelValue": ($event) => meData.value.firstname = $event,
                                type: "text",
                                placeholder: "Votre prénom",
                                class: `w-full ${validationErrors.value.firstname ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "lastname",
                      label: "Nom",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-pencil"${_scopeId3}></i>`);
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: meData.value.lastname,
                            "onUpdate:modelValue": ($event) => meData.value.lastname = $event,
                            type: "text",
                            placeholder: "Votre nom",
                            class: `w-full ${validationErrors.value.lastname ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, _parent4, _scopeId3));
                          _push4(`</div>`);
                        } else {
                          return [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(_component_InputText, {
                                modelValue: meData.value.lastname,
                                "onUpdate:modelValue": ($event) => meData.value.lastname = $event,
                                type: "text",
                                placeholder: "Votre nom",
                                class: `w-full ${validationErrors.value.lastname ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "col-span-2 mb-2",
                      name: "email",
                      label: "Email",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-envelope"${_scopeId3}></i>`);
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: meData.value.email,
                            "onUpdate:modelValue": ($event) => meData.value.email = $event,
                            type: "email",
                            placeholder: "Votre adresse email",
                            class: `w-full ${validationErrors.value.email ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, _parent4, _scopeId3));
                          _push4(`</div>`);
                        } else {
                          return [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-envelope" }),
                              createVNode(_component_InputText, {
                                modelValue: meData.value.email,
                                "onUpdate:modelValue": ($event) => meData.value.email = $event,
                                type: "email",
                                placeholder: "Votre adresse email",
                                class: `w-full ${validationErrors.value.email ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "password",
                      label: "Mot de passe",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-lock"${_scopeId3}></i>`);
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: meData.value.password,
                            "onUpdate:modelValue": ($event) => meData.value.password = $event,
                            type: "password",
                            placeholder: "Changer votre mot de passe",
                            class: `w-full ${validationErrors.value.password ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, _parent4, _scopeId3));
                          _push4(`</div>`);
                        } else {
                          return [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-lock" }),
                              createVNode(_component_InputText, {
                                modelValue: meData.value.password,
                                "onUpdate:modelValue": ($event) => meData.value.password = $event,
                                type: "password",
                                placeholder: "Changer votre mot de passe",
                                class: `w-full ${validationErrors.value.password ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "password_confirmation",
                      label: "Confirmation mot de passe",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-lock"${_scopeId3}></i>`);
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: meData.value.password_confirmation,
                            "onUpdate:modelValue": ($event) => meData.value.password_confirmation = $event,
                            type: "password",
                            placeholder: "Confirmer votre mot de passe",
                            class: `w-full ${validationErrors.value.password_confirmation ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, _parent4, _scopeId3));
                          _push4(`</div>`);
                        } else {
                          return [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-lock" }),
                              createVNode(_component_InputText, {
                                modelValue: meData.value.password_confirmation,
                                "onUpdate:modelValue": ($event) => meData.value.password_confirmation = $event,
                                type: "password",
                                placeholder: "Confirmer votre mot de passe",
                                class: `w-full ${validationErrors.value.password_confirmation ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`</div><div class="flex justify-center py-10"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_rounded_button, {
                      loading: loading.value,
                      type: "submit",
                      design: "1",
                      class: "px-[5rem]"
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(loading.value ? "Mise à jour en cours..." : "Mettre à jour")}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(loading.value ? "Mise à jour en cours..." : "Mettre à jour"), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`</div></form>`);
                  } else {
                    _push3(`<div class="flex items-center justify-center pb-[5rem] pt-[5rem]"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_ProgressSpinner, {
                      r: "",
                      style: { "width": "250px", "height": "250px" },
                      pt: {
                        spinner: { style: { animationDuration: "0.5s" } },
                        circle: {
                          style: {
                            stroke: "var(--primary-500)",
                            strokeWidth: 0.3,
                            animation: "none"
                          }
                        }
                      }
                    }, null, _parent3, _scopeId2));
                    _push3(`</div>`);
                  }
                  _push3(`</div>`);
                } else {
                  return [
                    createVNode("div", { class: "rounded-xl bg-white px-12 py-8" }, [
                      createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, " Mes informations personnelles "),
                      fetching.value ? (openBlock(), createBlock(_component_ProgressBar, {
                        key: 0,
                        mode: "indeterminate",
                        class: "mb-10",
                        style: { "height": "6px" }
                      })) : createCommentVNode("", true),
                      error2.value ? (openBlock(), createBlock(_component_Message, {
                        key: 1,
                        severity: "error"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(error2.value), 1)
                        ]),
                        _: 1
                      })) : createCommentVNode("", true),
                      success.value ? (openBlock(), createBlock(_component_Message, {
                        key: 2,
                        sticky: false,
                        life: "3000",
                        severity: "success"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(success.value), 1)
                        ]),
                        _: 1
                      })) : createCommentVNode("", true),
                      meData.value ? (openBlock(), createBlock("form", {
                        key: 3,
                        onSubmit: withModifiers(update, ["prevent"])
                      }, [
                        createVNode("div", { class: "grid-cols-2 gap-x-10 md:grid" }, [
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "firstname",
                            label: "Prénom",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-pencil" }),
                                createVNode(_component_InputText, {
                                  modelValue: meData.value.firstname,
                                  "onUpdate:modelValue": ($event) => meData.value.firstname = $event,
                                  type: "text",
                                  placeholder: "Votre prénom",
                                  class: `w-full ${validationErrors.value.firstname ? "p-invalid" : ""}`,
                                  disabled: loading.value
                                }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                              ])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "lastname",
                            label: "Nom",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-pencil" }),
                                createVNode(_component_InputText, {
                                  modelValue: meData.value.lastname,
                                  "onUpdate:modelValue": ($event) => meData.value.lastname = $event,
                                  type: "text",
                                  placeholder: "Votre nom",
                                  class: `w-full ${validationErrors.value.lastname ? "p-invalid" : ""}`,
                                  disabled: loading.value
                                }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                              ])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "col-span-2 mb-2",
                            name: "email",
                            label: "Email",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-envelope" }),
                                createVNode(_component_InputText, {
                                  modelValue: meData.value.email,
                                  "onUpdate:modelValue": ($event) => meData.value.email = $event,
                                  type: "email",
                                  placeholder: "Votre adresse email",
                                  class: `w-full ${validationErrors.value.email ? "p-invalid" : ""}`,
                                  disabled: loading.value
                                }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                              ])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "password",
                            label: "Mot de passe",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-lock" }),
                                createVNode(_component_InputText, {
                                  modelValue: meData.value.password,
                                  "onUpdate:modelValue": ($event) => meData.value.password = $event,
                                  type: "password",
                                  placeholder: "Changer votre mot de passe",
                                  class: `w-full ${validationErrors.value.password ? "p-invalid" : ""}`,
                                  disabled: loading.value
                                }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                              ])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "password_confirmation",
                            label: "Confirmation mot de passe",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-lock" }),
                                createVNode(_component_InputText, {
                                  modelValue: meData.value.password_confirmation,
                                  "onUpdate:modelValue": ($event) => meData.value.password_confirmation = $event,
                                  type: "password",
                                  placeholder: "Confirmer votre mot de passe",
                                  class: `w-full ${validationErrors.value.password_confirmation ? "p-invalid" : ""}`,
                                  disabled: loading.value
                                }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                              ])
                            ]),
                            _: 1
                          }, 8, ["errors"])
                        ]),
                        createVNode("div", { class: "flex justify-center py-10" }, [
                          createVNode(_component_rounded_button, {
                            loading: loading.value,
                            type: "submit",
                            design: "1",
                            class: "px-[5rem]"
                          }, {
                            default: withCtx(() => [
                              createTextVNode(toDisplayString(loading.value ? "Mise à jour en cours..." : "Mettre à jour"), 1)
                            ]),
                            _: 1
                          }, 8, ["loading"])
                        ])
                      ], 40, ["onSubmit"])) : (openBlock(), createBlock("div", {
                        key: 4,
                        class: "flex items-center justify-center pb-[5rem] pt-[5rem]"
                      }, [
                        createVNode(_component_ProgressSpinner, {
                          r: "",
                          style: { "width": "250px", "height": "250px" },
                          pt: {
                            spinner: { style: { animationDuration: "0.5s" } },
                            circle: {
                              style: {
                                stroke: "var(--primary-500)",
                                strokeWidth: 0.3,
                                animation: "none"
                              }
                            }
                          }
                        }, null, 8, ["pt"])
                      ]))
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container"
              }, {
                default: withCtx(() => [
                  createVNode("div", { class: "rounded-xl bg-white px-12 py-8" }, [
                    createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, " Mes informations personnelles "),
                    fetching.value ? (openBlock(), createBlock(_component_ProgressBar, {
                      key: 0,
                      mode: "indeterminate",
                      class: "mb-10",
                      style: { "height": "6px" }
                    })) : createCommentVNode("", true),
                    error2.value ? (openBlock(), createBlock(_component_Message, {
                      key: 1,
                      severity: "error"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(error2.value), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    success.value ? (openBlock(), createBlock(_component_Message, {
                      key: 2,
                      sticky: false,
                      life: "3000",
                      severity: "success"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(success.value), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    meData.value ? (openBlock(), createBlock("form", {
                      key: 3,
                      onSubmit: withModifiers(update, ["prevent"])
                    }, [
                      createVNode("div", { class: "grid-cols-2 gap-x-10 md:grid" }, [
                        createVNode(_component_FormField, {
                          class: "mb-2",
                          name: "firstname",
                          label: "Prénom",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(_component_InputText, {
                                modelValue: meData.value.firstname,
                                "onUpdate:modelValue": ($event) => meData.value.firstname = $event,
                                type: "text",
                                placeholder: "Votre prénom",
                                class: `w-full ${validationErrors.value.firstname ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-2",
                          name: "lastname",
                          label: "Nom",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(_component_InputText, {
                                modelValue: meData.value.lastname,
                                "onUpdate:modelValue": ($event) => meData.value.lastname = $event,
                                type: "text",
                                placeholder: "Votre nom",
                                class: `w-full ${validationErrors.value.lastname ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "col-span-2 mb-2",
                          name: "email",
                          label: "Email",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-envelope" }),
                              createVNode(_component_InputText, {
                                modelValue: meData.value.email,
                                "onUpdate:modelValue": ($event) => meData.value.email = $event,
                                type: "email",
                                placeholder: "Votre adresse email",
                                class: `w-full ${validationErrors.value.email ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-2",
                          name: "password",
                          label: "Mot de passe",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-lock" }),
                              createVNode(_component_InputText, {
                                modelValue: meData.value.password,
                                "onUpdate:modelValue": ($event) => meData.value.password = $event,
                                type: "password",
                                placeholder: "Changer votre mot de passe",
                                class: `w-full ${validationErrors.value.password ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-2",
                          name: "password_confirmation",
                          label: "Confirmation mot de passe",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-lock" }),
                              createVNode(_component_InputText, {
                                modelValue: meData.value.password_confirmation,
                                "onUpdate:modelValue": ($event) => meData.value.password_confirmation = $event,
                                type: "password",
                                placeholder: "Confirmer votre mot de passe",
                                class: `w-full ${validationErrors.value.password_confirmation ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ]),
                          _: 1
                        }, 8, ["errors"])
                      ]),
                      createVNode("div", { class: "flex justify-center py-10" }, [
                        createVNode(_component_rounded_button, {
                          loading: loading.value,
                          type: "submit",
                          design: "1",
                          class: "px-[5rem]"
                        }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(loading.value ? "Mise à jour en cours..." : "Mettre à jour"), 1)
                          ]),
                          _: 1
                        }, 8, ["loading"])
                      ])
                    ], 40, ["onSubmit"])) : (openBlock(), createBlock("div", {
                      key: 4,
                      class: "flex items-center justify-center pb-[5rem] pt-[5rem]"
                    }, [
                      createVNode(_component_ProgressSpinner, {
                        r: "",
                        style: { "width": "250px", "height": "250px" },
                        pt: {
                          spinner: { style: { animationDuration: "0.5s" } },
                          circle: {
                            style: {
                              stroke: "var(--primary-500)",
                              strokeWidth: 0.3,
                              animation: "none"
                            }
                          }
                        }
                      }, null, 8, ["pt"])
                    ]))
                  ])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$9 = _sfc_main$9.setup;
_sfc_main$9.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/MeForm.vue");
  return _sfc_setup$9 ? _sfc_setup$9(props, ctx) : void 0;
};
const __nuxt_component_2 = _sfc_main$9;
const _sfc_main$8 = {
  __name: "CompanyForm",
  __ssrInlineRender: true,
  setup(__props) {
    const { $api, $listen, $unListen, $event, $toast } = useNuxtApp();
    const authStore = useAuthStore();
    const companyData = ref(null);
    const loading = ref(false);
    const success = ref(null);
    const error2 = ref(null);
    const validationErrors = ref({});
    const fetching = ref(false);
    const dayjs = useDayjs();
    const { company } = authStore;
    const update = async () => {
      loading.value = true;
      error2.value = null;
      success.value = null;
      validationErrors.value = {};
      const toastId = $toast.loading("Mise à jour en cours...");
      const { errorHandler: errorHandler2, convertToSuccess: convertToSuccess2 } = useUtils();
      try {
        const companyFormData = new FormData();
        for (let key in companyData.value) {
          let value = companyData.value[key];
          if (["clearance", "kbis"].includes(key)) {
            if (value) {
              companyFormData.append(key, value);
            }
          } else {
            companyFormData.append(key, value);
          }
        }
        companyFormData.append(
          "clearance_expires_at",
          dayjs(companyData.value.clearance_expires_at).format(
            "YYYY-MM-DDTHH:mm:ss"
          )
        );
        const company2 = await $api.call(
          "post",
          $api.route("me.company"),
          companyFormData,
          {
            _method: "PUT"
          }
        );
        if (!company2.mobile_verified_at) {
          $event("open-mobile-modal");
        }
        companyData.value = company2;
        companyData.value.clearance = null;
        companyData.value.kbis = null;
        companyData.value.clearance_expires_at = dayjs(
          companyData.value.clearance_expires_at
        ).toDate();
        convertToSuccess2(toastId, "Informations de la société mises à jour");
        success.value = "Informations de la société mises à jour";
        authStore.$patch({
          company: company2
        });
      } catch (e) {
        errorHandler2(e, error2, validationErrors, toastId);
      } finally {
        loading.value = false;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_wrapper = __nuxt_component_0$1;
      const _component_section_container = __nuxt_component_1$1;
      const _component_ProgressBar = resolveComponent("ProgressBar");
      const _component_Message = resolveComponent("Message");
      const _component_FormField = __nuxt_component_5$1;
      const _component_InputText = resolveComponent("InputText");
      const _component_InputMask = resolveComponent("InputMask");
      const _component_Tag = resolveComponent("Tag");
      const _component_rounded_button = __nuxt_component_8;
      const _component_ProgressSpinner = resolveComponent("ProgressSpinner");
      _push(ssrRenderComponent(_component_section_wrapper, mergeProps({ class: "bg-background-3 pb-12" }, _attrs), {
        default: withCtx((_2, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container"
            }, {
              default: withCtx((_3, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="rounded-xl bg-white px-12 py-8"${_scopeId2}><h2 class="text-primary mb-10 text-[1.563rem] font-bold"${_scopeId2}>Ma société</h2>`);
                  if (fetching.value) {
                    _push3(ssrRenderComponent(_component_ProgressBar, {
                      mode: "indeterminate",
                      class: "mb-10",
                      style: { "height": "6px" }
                    }, null, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (error2.value) {
                    _push3(ssrRenderComponent(_component_Message, { severity: "error" }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(error2.value)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(error2.value), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (success.value) {
                    _push3(ssrRenderComponent(_component_Message, {
                      sticky: false,
                      life: "3000",
                      severity: "success"
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(success.value)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(success.value), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (companyData.value) {
                    _push3(`<form${_scopeId2}><div class="mb-10 grid-cols-2 gap-x-10 md:grid"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "name",
                      label: "Nom de l'entreprise",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-pencil"${_scopeId3}></i>`);
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: companyData.value.name,
                            "onUpdate:modelValue": ($event2) => companyData.value.name = $event2,
                            type: "text",
                            placeholder: "Nom de l'entreprise",
                            class: `w-full ${validationErrors.value.name ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, _parent4, _scopeId3));
                          _push4(`</div>`);
                        } else {
                          return [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(_component_InputText, {
                                modelValue: companyData.value.name,
                                "onUpdate:modelValue": ($event2) => companyData.value.name = $event2,
                                type: "text",
                                placeholder: "Nom de l'entreprise",
                                class: `w-full ${validationErrors.value.name ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "siret",
                      label: "Numéro de SIRET",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-pencil"${_scopeId3}></i>`);
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: companyData.value.siret,
                            "onUpdate:modelValue": ($event2) => companyData.value.siret = $event2,
                            type: "text",
                            placeholder: "Le numéro de SIRET de votre entreprise",
                            class: `w-full ${validationErrors.value.siret ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, _parent4, _scopeId3));
                          _push4(`</div>`);
                        } else {
                          return [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(_component_InputText, {
                                modelValue: companyData.value.siret,
                                "onUpdate:modelValue": ($event2) => companyData.value.siret = $event2,
                                type: "text",
                                placeholder: "Le numéro de SIRET de votre entreprise",
                                class: `w-full ${validationErrors.value.siret ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "address",
                      label: "Adresse de l'entreprise",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-pencil"${_scopeId3}></i>`);
                          _push4(ssrRenderComponent(_component_InputText, {
                            modelValue: companyData.value.address,
                            "onUpdate:modelValue": ($event2) => companyData.value.address = $event2,
                            type: "text",
                            placeholder: "Adresse de l'entreprise",
                            class: `w-full ${validationErrors.value.address ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, _parent4, _scopeId3));
                          _push4(`</div>`);
                        } else {
                          return [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(_component_InputText, {
                                modelValue: companyData.value.address,
                                "onUpdate:modelValue": ($event2) => companyData.value.address = $event2,
                                type: "text",
                                placeholder: "Adresse de l'entreprise",
                                class: `w-full ${validationErrors.value.address ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "city_id",
                      label: "Ville et Code postal",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(CitySelectField, {
                            placeholder: "Choisir une ville",
                            modelValue: companyData.value.city_id,
                            "onUpdate:modelValue": ($event2) => companyData.value.city_id = $event2
                          }, null, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(CitySelectField, {
                              placeholder: "Choisir une ville",
                              modelValue: companyData.value.city_id,
                              "onUpdate:modelValue": ($event2) => companyData.value.city_id = $event2
                            }, null, 8, ["modelValue", "onUpdate:modelValue"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "phone",
                      label: "Téléphone fixe",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-phone"${_scopeId3}></i>`);
                          _push4(ssrRenderComponent(_component_InputMask, {
                            placeholder: "Téléphone fixe",
                            mask: "99 99 99 99 99",
                            unmask: "",
                            modelValue: companyData.value.phone,
                            "onUpdate:modelValue": ($event2) => companyData.value.phone = $event2,
                            class: `w-full ${validationErrors.value.phone ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, _parent4, _scopeId3));
                          _push4(`</div>`);
                        } else {
                          return [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-phone" }),
                              createVNode(_component_InputMask, {
                                placeholder: "Téléphone fixe",
                                mask: "99 99 99 99 99",
                                unmask: "",
                                modelValue: companyData.value.phone,
                                "onUpdate:modelValue": ($event2) => companyData.value.phone = $event2,
                                class: `w-full ${validationErrors.value.phone ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-2",
                      name: "mobile",
                      label: "Téléphone mobile",
                      errors: validationErrors.value
                    }, {
                      "after-label": withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_Tag, {
                            severity: unref(company).mobile_verified_at ? "success" : "danger",
                            value: unref(company).mobile_verified_at ? "Vérifié" : "Non vérifié"
                          }, null, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_Tag, {
                              severity: unref(company).mobile_verified_at ? "success" : "danger",
                              value: unref(company).mobile_verified_at ? "Vérifié" : "Non vérifié"
                            }, null, 8, ["severity", "value"])
                          ];
                        }
                      }),
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-mobile"${_scopeId3}></i>`);
                          _push4(ssrRenderComponent(_component_InputMask, {
                            placeholder: "Téléphone mobile",
                            mask: "+33 (9)9 99 99 99 99",
                            unmask: "",
                            modelValue: companyData.value.mobile,
                            "onUpdate:modelValue": ($event2) => companyData.value.mobile = $event2,
                            class: `w-full ${validationErrors.value.mobile ? "p-invalid" : ""}`,
                            disabled: loading.value
                          }, null, _parent4, _scopeId3));
                          _push4(`</div><small${_scopeId3}>Une validation par SMS est nécessaire en cas de modification du numéro de téléphone mobile. </small>`);
                        } else {
                          return [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-mobile" }),
                              createVNode(_component_InputMask, {
                                placeholder: "Téléphone mobile",
                                mask: "+33 (9)9 99 99 99 99",
                                unmask: "",
                                modelValue: companyData.value.mobile,
                                "onUpdate:modelValue": ($event2) => companyData.value.mobile = $event2,
                                class: `w-full ${validationErrors.value.mobile ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ]),
                            createVNode("small", null, "Une validation par SMS est nécessaire en cas de modification du numéro de téléphone mobile. ")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      name: "clearance_expires_at",
                      label: "Date de fin de validité de l'habilitation",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`<div class="p-input-icon-right"${_scopeId3}><i class="pi pi-pencil"${_scopeId3}></i>`);
                          _push4(ssrRenderComponent(unref(script), {
                            disabled: loading.value,
                            dateFormat: "dd/mm/yy",
                            "hour-format": "24",
                            showIcon: "",
                            modelValue: companyData.value.clearance_expires_at,
                            "onUpdate:modelValue": ($event2) => companyData.value.clearance_expires_at = $event2,
                            "min-date": unref(dayjs)().toDate(),
                            placeholder: "Date de fin de validité de l'habilitation",
                            class: `w-full ${validationErrors.value.clearance_expires_at ? "p-invalid" : ""}`
                          }, null, _parent4, _scopeId3));
                          _push4(`</div>`);
                          if (!unref(company).clearance_need_verification) {
                            _push4(`<small${_scopeId3}>Une modification de ce champ entraînera une vérification de la validité de votre habilitation. Vous ne pourrez plus utiliser la plateforme le temps de la vérification. </small>`);
                          } else {
                            _push4(`<small class="text-success"${_scopeId3}>Votre habilitation est en attente de vérification par notre équipe. Vous serez notifié par email dès que votre habilitation sera validée.</small>`);
                          }
                        } else {
                          return [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(unref(script), {
                                disabled: loading.value,
                                dateFormat: "dd/mm/yy",
                                "hour-format": "24",
                                showIcon: "",
                                modelValue: companyData.value.clearance_expires_at,
                                "onUpdate:modelValue": ($event2) => companyData.value.clearance_expires_at = $event2,
                                "min-date": unref(dayjs)().toDate(),
                                placeholder: "Date de fin de validité de l'habilitation",
                                class: `w-full ${validationErrors.value.clearance_expires_at ? "p-invalid" : ""}`
                              }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue", "min-date", "class"])
                            ]),
                            !unref(company).clearance_need_verification ? (openBlock(), createBlock("small", { key: 0 }, "Une modification de ce champ entraînera une vérification de la validité de votre habilitation. Vous ne pourrez plus utiliser la plateforme le temps de la vérification. ")) : (openBlock(), createBlock("small", {
                              key: 1,
                              class: "text-success"
                            }, "Votre habilitation est en attente de vérification par notre équipe. Vous serez notifié par email dès que votre habilitation sera validée."))
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`</div><h2 class="text-primary mb-10 text-[1.3rem] font-bold"${_scopeId2}> Pièces justificatives </h2><div class="grid-cols-2 gap-x-10 md:grid"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-4",
                      name: "clearance",
                      label: "Habilitation",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          if (companyData.value.clearance_url) {
                            _push4(`<a class="bg-secondary mb-2 flex items-center justify-between gap-3 rounded p-3 px-5 font-bold text-white"${ssrRenderAttr("href", companyData.value.clearance_url)} target="_blank"${_scopeId3}><i class="pi pi-eye"${_scopeId3}></i><span class="grow text-center"${_scopeId3}>Voir mon habilitation actuelle</span></a>`);
                          } else {
                            _push4(`<!---->`);
                          }
                          if (companyData.value.clearance) {
                            _push4(`<div class="bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"${_scopeId3}><span class="font-normal"${_scopeId3}>${ssrInterpolate(companyData.value.clearance.name)}</span><span class="cursor-pointer font-normal"${_scopeId3}>Annuler</span></div>`);
                          } else {
                            _push4(ssrRenderComponent(unref(script$1), {
                              onUploader: (e) => {
                                companyData.value.clearance = e.files[0];
                              },
                              accept: "application/pdf",
                              name: "clearance",
                              auto: "",
                              mode: "basic",
                              modelValue: companyData.value.clearance,
                              "onUpdate:modelValue": ($event2) => companyData.value.clearance = $event2,
                              class: "w-full",
                              "choose-label": "Mettre à jour mon habilitation",
                              customUpload: true,
                              pt: {
                                chooseButton: { style: "background-color: #96B938 " }
                              },
                              disabled: loading.value
                            }, null, _parent4, _scopeId3));
                          }
                          if (!unref(company).clearance_need_verification) {
                            _push4(`<small class="mt-2"${_scopeId3}>Une modification de ce champ entraînera une vérification de la validité de votre habilitation. Vous ne pourrez plus utiliser la plateforme le temps de la vérification. </small>`);
                          } else {
                            _push4(`<small class="text-success mt-2"${_scopeId3}>Votre habilitation est en attente de vérification par notre équipe. Vous serez notifié par email dès que votre habilitation sera validée.</small>`);
                          }
                        } else {
                          return [
                            companyData.value.clearance_url ? (openBlock(), createBlock("a", {
                              key: 0,
                              class: "bg-secondary mb-2 flex items-center justify-between gap-3 rounded p-3 px-5 font-bold text-white",
                              href: companyData.value.clearance_url,
                              target: "_blank"
                            }, [
                              createVNode("i", { class: "pi pi-eye" }),
                              createVNode("span", { class: "grow text-center" }, "Voir mon habilitation actuelle")
                            ], 8, ["href"])) : createCommentVNode("", true),
                            companyData.value.clearance ? (openBlock(), createBlock("div", {
                              key: 1,
                              class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                            }, [
                              createVNode("span", { class: "font-normal" }, toDisplayString(companyData.value.clearance.name), 1),
                              createVNode("span", {
                                onClick: ($event2) => companyData.value.clearance = null,
                                class: "cursor-pointer font-normal"
                              }, "Annuler", 8, ["onClick"])
                            ])) : (openBlock(), createBlock(unref(script$1), {
                              key: 2,
                              onUploader: (e) => {
                                companyData.value.clearance = e.files[0];
                              },
                              accept: "application/pdf",
                              name: "clearance",
                              auto: "",
                              mode: "basic",
                              modelValue: companyData.value.clearance,
                              "onUpdate:modelValue": ($event2) => companyData.value.clearance = $event2,
                              class: "w-full",
                              "choose-label": "Mettre à jour mon habilitation",
                              customUpload: true,
                              pt: {
                                chooseButton: { style: "background-color: #96B938 " }
                              },
                              disabled: loading.value
                            }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"])),
                            !unref(company).clearance_need_verification ? (openBlock(), createBlock("small", {
                              key: 3,
                              class: "mt-2"
                            }, "Une modification de ce champ entraînera une vérification de la validité de votre habilitation. Vous ne pourrez plus utiliser la plateforme le temps de la vérification. ")) : (openBlock(), createBlock("small", {
                              key: 4,
                              class: "text-success mt-2"
                            }, "Votre habilitation est en attente de vérification par notre équipe. Vous serez notifié par email dès que votre habilitation sera validée."))
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_FormField, {
                      class: "mb-4",
                      name: "kbis",
                      label: "Extrait Kbis",
                      errors: validationErrors.value
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          if (companyData.value.kbis_url) {
                            _push4(`<a class="bg-secondary mb-2 flex items-center justify-between gap-3 rounded p-3 px-5 font-bold text-white"${ssrRenderAttr("href", companyData.value.kbis_url)} target="_blank"${_scopeId3}><i class="pi pi-eye"${_scopeId3}></i><span class="grow text-center"${_scopeId3}>Voir mon KBIS actuel</span></a>`);
                          } else {
                            _push4(`<!---->`);
                          }
                          if (companyData.value.kbis) {
                            _push4(`<div class="bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"${_scopeId3}><span class="font-normal"${_scopeId3}>${ssrInterpolate(companyData.value.kbis.name)}</span><span class="cursor-pointer font-normal"${_scopeId3}>Annuler</span></div>`);
                          } else {
                            _push4(ssrRenderComponent(unref(script$1), {
                              onUploader: (e) => {
                                companyData.value.kbis = e.files[0];
                              },
                              accept: "application/pdf",
                              name: "kbis",
                              auto: "",
                              mode: "basic",
                              modelValue: companyData.value.kbis,
                              "onUpdate:modelValue": ($event2) => companyData.value.kbis = $event2,
                              class: "w-full",
                              "choose-label": "Mettre à jour mon KBIS",
                              customUpload: true,
                              pt: {
                                chooseButton: { style: "background-color: #96B938 " }
                              },
                              disabled: loading.value
                            }, null, _parent4, _scopeId3));
                          }
                        } else {
                          return [
                            companyData.value.kbis_url ? (openBlock(), createBlock("a", {
                              key: 0,
                              class: "bg-secondary mb-2 flex items-center justify-between gap-3 rounded p-3 px-5 font-bold text-white",
                              href: companyData.value.kbis_url,
                              target: "_blank"
                            }, [
                              createVNode("i", { class: "pi pi-eye" }),
                              createVNode("span", { class: "grow text-center" }, "Voir mon KBIS actuel")
                            ], 8, ["href"])) : createCommentVNode("", true),
                            companyData.value.kbis ? (openBlock(), createBlock("div", {
                              key: 1,
                              class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                            }, [
                              createVNode("span", { class: "font-normal" }, toDisplayString(companyData.value.kbis.name), 1),
                              createVNode("span", {
                                onClick: ($event2) => companyData.value.kbis = null,
                                class: "cursor-pointer font-normal"
                              }, "Annuler", 8, ["onClick"])
                            ])) : (openBlock(), createBlock(unref(script$1), {
                              key: 2,
                              onUploader: (e) => {
                                companyData.value.kbis = e.files[0];
                              },
                              accept: "application/pdf",
                              name: "kbis",
                              auto: "",
                              mode: "basic",
                              modelValue: companyData.value.kbis,
                              "onUpdate:modelValue": ($event2) => companyData.value.kbis = $event2,
                              class: "w-full",
                              "choose-label": "Mettre à jour mon KBIS",
                              customUpload: true,
                              pt: {
                                chooseButton: { style: "background-color: #96B938 " }
                              },
                              disabled: loading.value
                            }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"]))
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`</div><div class="flex justify-center py-10"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_rounded_button, {
                      loading: loading.value,
                      type: "submit",
                      design: "1",
                      class: "px-[5rem]"
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(loading.value ? "Mise à jour en cours..." : "Mettre à jour")}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(loading.value ? "Mise à jour en cours..." : "Mettre à jour"), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`</div></form>`);
                  } else {
                    _push3(`<div class="flex items-center justify-center pb-[5rem] pt-[5rem]"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_ProgressSpinner, {
                      style: { "width": "250px", "height": "250px" },
                      pt: {
                        spinner: { style: { animationDuration: "0.5s" } },
                        circle: {
                          style: {
                            stroke: "var(--primary-500)",
                            strokeWidth: 0.3,
                            animation: "none"
                          }
                        }
                      }
                    }, null, _parent3, _scopeId2));
                    _push3(`</div>`);
                  }
                  _push3(`</div>`);
                } else {
                  return [
                    createVNode("div", { class: "rounded-xl bg-white px-12 py-8" }, [
                      createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, "Ma société"),
                      fetching.value ? (openBlock(), createBlock(_component_ProgressBar, {
                        key: 0,
                        mode: "indeterminate",
                        class: "mb-10",
                        style: { "height": "6px" }
                      })) : createCommentVNode("", true),
                      error2.value ? (openBlock(), createBlock(_component_Message, {
                        key: 1,
                        severity: "error"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(error2.value), 1)
                        ]),
                        _: 1
                      })) : createCommentVNode("", true),
                      success.value ? (openBlock(), createBlock(_component_Message, {
                        key: 2,
                        sticky: false,
                        life: "3000",
                        severity: "success"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(success.value), 1)
                        ]),
                        _: 1
                      })) : createCommentVNode("", true),
                      companyData.value ? (openBlock(), createBlock("form", {
                        key: 3,
                        onSubmit: withModifiers(update, ["prevent"])
                      }, [
                        createVNode("div", { class: "mb-10 grid-cols-2 gap-x-10 md:grid" }, [
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "name",
                            label: "Nom de l'entreprise",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-pencil" }),
                                createVNode(_component_InputText, {
                                  modelValue: companyData.value.name,
                                  "onUpdate:modelValue": ($event2) => companyData.value.name = $event2,
                                  type: "text",
                                  placeholder: "Nom de l'entreprise",
                                  class: `w-full ${validationErrors.value.name ? "p-invalid" : ""}`,
                                  disabled: loading.value
                                }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                              ])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "siret",
                            label: "Numéro de SIRET",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-pencil" }),
                                createVNode(_component_InputText, {
                                  modelValue: companyData.value.siret,
                                  "onUpdate:modelValue": ($event2) => companyData.value.siret = $event2,
                                  type: "text",
                                  placeholder: "Le numéro de SIRET de votre entreprise",
                                  class: `w-full ${validationErrors.value.siret ? "p-invalid" : ""}`,
                                  disabled: loading.value
                                }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                              ])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "address",
                            label: "Adresse de l'entreprise",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-pencil" }),
                                createVNode(_component_InputText, {
                                  modelValue: companyData.value.address,
                                  "onUpdate:modelValue": ($event2) => companyData.value.address = $event2,
                                  type: "text",
                                  placeholder: "Adresse de l'entreprise",
                                  class: `w-full ${validationErrors.value.address ? "p-invalid" : ""}`,
                                  disabled: loading.value
                                }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                              ])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "city_id",
                            label: "Ville et Code postal",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode(CitySelectField, {
                                placeholder: "Choisir une ville",
                                modelValue: companyData.value.city_id,
                                "onUpdate:modelValue": ($event2) => companyData.value.city_id = $event2
                              }, null, 8, ["modelValue", "onUpdate:modelValue"])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "phone",
                            label: "Téléphone fixe",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-phone" }),
                                createVNode(_component_InputMask, {
                                  placeholder: "Téléphone fixe",
                                  mask: "99 99 99 99 99",
                                  unmask: "",
                                  modelValue: companyData.value.phone,
                                  "onUpdate:modelValue": ($event2) => companyData.value.phone = $event2,
                                  class: `w-full ${validationErrors.value.phone ? "p-invalid" : ""}`,
                                  disabled: loading.value
                                }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                              ])
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "mb-2",
                            name: "mobile",
                            label: "Téléphone mobile",
                            errors: validationErrors.value
                          }, {
                            "after-label": withCtx(() => [
                              createVNode(_component_Tag, {
                                severity: unref(company).mobile_verified_at ? "success" : "danger",
                                value: unref(company).mobile_verified_at ? "Vérifié" : "Non vérifié"
                              }, null, 8, ["severity", "value"])
                            ]),
                            default: withCtx(() => [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-mobile" }),
                                createVNode(_component_InputMask, {
                                  placeholder: "Téléphone mobile",
                                  mask: "+33 (9)9 99 99 99 99",
                                  unmask: "",
                                  modelValue: companyData.value.mobile,
                                  "onUpdate:modelValue": ($event2) => companyData.value.mobile = $event2,
                                  class: `w-full ${validationErrors.value.mobile ? "p-invalid" : ""}`,
                                  disabled: loading.value
                                }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                              ]),
                              createVNode("small", null, "Une validation par SMS est nécessaire en cas de modification du numéro de téléphone mobile. ")
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            name: "clearance_expires_at",
                            label: "Date de fin de validité de l'habilitation",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              createVNode("div", { class: "p-input-icon-right" }, [
                                createVNode("i", { class: "pi pi-pencil" }),
                                createVNode(unref(script), {
                                  disabled: loading.value,
                                  dateFormat: "dd/mm/yy",
                                  "hour-format": "24",
                                  showIcon: "",
                                  modelValue: companyData.value.clearance_expires_at,
                                  "onUpdate:modelValue": ($event2) => companyData.value.clearance_expires_at = $event2,
                                  "min-date": unref(dayjs)().toDate(),
                                  placeholder: "Date de fin de validité de l'habilitation",
                                  class: `w-full ${validationErrors.value.clearance_expires_at ? "p-invalid" : ""}`
                                }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue", "min-date", "class"])
                              ]),
                              !unref(company).clearance_need_verification ? (openBlock(), createBlock("small", { key: 0 }, "Une modification de ce champ entraînera une vérification de la validité de votre habilitation. Vous ne pourrez plus utiliser la plateforme le temps de la vérification. ")) : (openBlock(), createBlock("small", {
                                key: 1,
                                class: "text-success"
                              }, "Votre habilitation est en attente de vérification par notre équipe. Vous serez notifié par email dès que votre habilitation sera validée."))
                            ]),
                            _: 1
                          }, 8, ["errors"])
                        ]),
                        createVNode("h2", { class: "text-primary mb-10 text-[1.3rem] font-bold" }, " Pièces justificatives "),
                        createVNode("div", { class: "grid-cols-2 gap-x-10 md:grid" }, [
                          createVNode(_component_FormField, {
                            class: "mb-4",
                            name: "clearance",
                            label: "Habilitation",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              companyData.value.clearance_url ? (openBlock(), createBlock("a", {
                                key: 0,
                                class: "bg-secondary mb-2 flex items-center justify-between gap-3 rounded p-3 px-5 font-bold text-white",
                                href: companyData.value.clearance_url,
                                target: "_blank"
                              }, [
                                createVNode("i", { class: "pi pi-eye" }),
                                createVNode("span", { class: "grow text-center" }, "Voir mon habilitation actuelle")
                              ], 8, ["href"])) : createCommentVNode("", true),
                              companyData.value.clearance ? (openBlock(), createBlock("div", {
                                key: 1,
                                class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                              }, [
                                createVNode("span", { class: "font-normal" }, toDisplayString(companyData.value.clearance.name), 1),
                                createVNode("span", {
                                  onClick: ($event2) => companyData.value.clearance = null,
                                  class: "cursor-pointer font-normal"
                                }, "Annuler", 8, ["onClick"])
                              ])) : (openBlock(), createBlock(unref(script$1), {
                                key: 2,
                                onUploader: (e) => {
                                  companyData.value.clearance = e.files[0];
                                },
                                accept: "application/pdf",
                                name: "clearance",
                                auto: "",
                                mode: "basic",
                                modelValue: companyData.value.clearance,
                                "onUpdate:modelValue": ($event2) => companyData.value.clearance = $event2,
                                class: "w-full",
                                "choose-label": "Mettre à jour mon habilitation",
                                customUpload: true,
                                pt: {
                                  chooseButton: { style: "background-color: #96B938 " }
                                },
                                disabled: loading.value
                              }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"])),
                              !unref(company).clearance_need_verification ? (openBlock(), createBlock("small", {
                                key: 3,
                                class: "mt-2"
                              }, "Une modification de ce champ entraînera une vérification de la validité de votre habilitation. Vous ne pourrez plus utiliser la plateforme le temps de la vérification. ")) : (openBlock(), createBlock("small", {
                                key: 4,
                                class: "text-success mt-2"
                              }, "Votre habilitation est en attente de vérification par notre équipe. Vous serez notifié par email dès que votre habilitation sera validée."))
                            ]),
                            _: 1
                          }, 8, ["errors"]),
                          createVNode(_component_FormField, {
                            class: "mb-4",
                            name: "kbis",
                            label: "Extrait Kbis",
                            errors: validationErrors.value
                          }, {
                            default: withCtx(() => [
                              companyData.value.kbis_url ? (openBlock(), createBlock("a", {
                                key: 0,
                                class: "bg-secondary mb-2 flex items-center justify-between gap-3 rounded p-3 px-5 font-bold text-white",
                                href: companyData.value.kbis_url,
                                target: "_blank"
                              }, [
                                createVNode("i", { class: "pi pi-eye" }),
                                createVNode("span", { class: "grow text-center" }, "Voir mon KBIS actuel")
                              ], 8, ["href"])) : createCommentVNode("", true),
                              companyData.value.kbis ? (openBlock(), createBlock("div", {
                                key: 1,
                                class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                              }, [
                                createVNode("span", { class: "font-normal" }, toDisplayString(companyData.value.kbis.name), 1),
                                createVNode("span", {
                                  onClick: ($event2) => companyData.value.kbis = null,
                                  class: "cursor-pointer font-normal"
                                }, "Annuler", 8, ["onClick"])
                              ])) : (openBlock(), createBlock(unref(script$1), {
                                key: 2,
                                onUploader: (e) => {
                                  companyData.value.kbis = e.files[0];
                                },
                                accept: "application/pdf",
                                name: "kbis",
                                auto: "",
                                mode: "basic",
                                modelValue: companyData.value.kbis,
                                "onUpdate:modelValue": ($event2) => companyData.value.kbis = $event2,
                                class: "w-full",
                                "choose-label": "Mettre à jour mon KBIS",
                                customUpload: true,
                                pt: {
                                  chooseButton: { style: "background-color: #96B938 " }
                                },
                                disabled: loading.value
                              }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"]))
                            ]),
                            _: 1
                          }, 8, ["errors"])
                        ]),
                        createVNode("div", { class: "flex justify-center py-10" }, [
                          createVNode(_component_rounded_button, {
                            loading: loading.value,
                            type: "submit",
                            design: "1",
                            class: "px-[5rem]"
                          }, {
                            default: withCtx(() => [
                              createTextVNode(toDisplayString(loading.value ? "Mise à jour en cours..." : "Mettre à jour"), 1)
                            ]),
                            _: 1
                          }, 8, ["loading"])
                        ])
                      ], 40, ["onSubmit"])) : (openBlock(), createBlock("div", {
                        key: 4,
                        class: "flex items-center justify-center pb-[5rem] pt-[5rem]"
                      }, [
                        createVNode(_component_ProgressSpinner, {
                          style: { "width": "250px", "height": "250px" },
                          pt: {
                            spinner: { style: { animationDuration: "0.5s" } },
                            circle: {
                              style: {
                                stroke: "var(--primary-500)",
                                strokeWidth: 0.3,
                                animation: "none"
                              }
                            }
                          }
                        }, null, 8, ["pt"])
                      ]))
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container"
              }, {
                default: withCtx(() => [
                  createVNode("div", { class: "rounded-xl bg-white px-12 py-8" }, [
                    createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, "Ma société"),
                    fetching.value ? (openBlock(), createBlock(_component_ProgressBar, {
                      key: 0,
                      mode: "indeterminate",
                      class: "mb-10",
                      style: { "height": "6px" }
                    })) : createCommentVNode("", true),
                    error2.value ? (openBlock(), createBlock(_component_Message, {
                      key: 1,
                      severity: "error"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(error2.value), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    success.value ? (openBlock(), createBlock(_component_Message, {
                      key: 2,
                      sticky: false,
                      life: "3000",
                      severity: "success"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(success.value), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    companyData.value ? (openBlock(), createBlock("form", {
                      key: 3,
                      onSubmit: withModifiers(update, ["prevent"])
                    }, [
                      createVNode("div", { class: "mb-10 grid-cols-2 gap-x-10 md:grid" }, [
                        createVNode(_component_FormField, {
                          class: "mb-2",
                          name: "name",
                          label: "Nom de l'entreprise",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(_component_InputText, {
                                modelValue: companyData.value.name,
                                "onUpdate:modelValue": ($event2) => companyData.value.name = $event2,
                                type: "text",
                                placeholder: "Nom de l'entreprise",
                                class: `w-full ${validationErrors.value.name ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-2",
                          name: "siret",
                          label: "Numéro de SIRET",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(_component_InputText, {
                                modelValue: companyData.value.siret,
                                "onUpdate:modelValue": ($event2) => companyData.value.siret = $event2,
                                type: "text",
                                placeholder: "Le numéro de SIRET de votre entreprise",
                                class: `w-full ${validationErrors.value.siret ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-2",
                          name: "address",
                          label: "Adresse de l'entreprise",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(_component_InputText, {
                                modelValue: companyData.value.address,
                                "onUpdate:modelValue": ($event2) => companyData.value.address = $event2,
                                type: "text",
                                placeholder: "Adresse de l'entreprise",
                                class: `w-full ${validationErrors.value.address ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-2",
                          name: "city_id",
                          label: "Ville et Code postal",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode(CitySelectField, {
                              placeholder: "Choisir une ville",
                              modelValue: companyData.value.city_id,
                              "onUpdate:modelValue": ($event2) => companyData.value.city_id = $event2
                            }, null, 8, ["modelValue", "onUpdate:modelValue"])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-2",
                          name: "phone",
                          label: "Téléphone fixe",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-phone" }),
                              createVNode(_component_InputMask, {
                                placeholder: "Téléphone fixe",
                                mask: "99 99 99 99 99",
                                unmask: "",
                                modelValue: companyData.value.phone,
                                "onUpdate:modelValue": ($event2) => companyData.value.phone = $event2,
                                class: `w-full ${validationErrors.value.phone ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ])
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-2",
                          name: "mobile",
                          label: "Téléphone mobile",
                          errors: validationErrors.value
                        }, {
                          "after-label": withCtx(() => [
                            createVNode(_component_Tag, {
                              severity: unref(company).mobile_verified_at ? "success" : "danger",
                              value: unref(company).mobile_verified_at ? "Vérifié" : "Non vérifié"
                            }, null, 8, ["severity", "value"])
                          ]),
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-mobile" }),
                              createVNode(_component_InputMask, {
                                placeholder: "Téléphone mobile",
                                mask: "+33 (9)9 99 99 99 99",
                                unmask: "",
                                modelValue: companyData.value.mobile,
                                "onUpdate:modelValue": ($event2) => companyData.value.mobile = $event2,
                                class: `w-full ${validationErrors.value.mobile ? "p-invalid" : ""}`,
                                disabled: loading.value
                              }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                            ]),
                            createVNode("small", null, "Une validation par SMS est nécessaire en cas de modification du numéro de téléphone mobile. ")
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          name: "clearance_expires_at",
                          label: "Date de fin de validité de l'habilitation",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            createVNode("div", { class: "p-input-icon-right" }, [
                              createVNode("i", { class: "pi pi-pencil" }),
                              createVNode(unref(script), {
                                disabled: loading.value,
                                dateFormat: "dd/mm/yy",
                                "hour-format": "24",
                                showIcon: "",
                                modelValue: companyData.value.clearance_expires_at,
                                "onUpdate:modelValue": ($event2) => companyData.value.clearance_expires_at = $event2,
                                "min-date": unref(dayjs)().toDate(),
                                placeholder: "Date de fin de validité de l'habilitation",
                                class: `w-full ${validationErrors.value.clearance_expires_at ? "p-invalid" : ""}`
                              }, null, 8, ["disabled", "modelValue", "onUpdate:modelValue", "min-date", "class"])
                            ]),
                            !unref(company).clearance_need_verification ? (openBlock(), createBlock("small", { key: 0 }, "Une modification de ce champ entraînera une vérification de la validité de votre habilitation. Vous ne pourrez plus utiliser la plateforme le temps de la vérification. ")) : (openBlock(), createBlock("small", {
                              key: 1,
                              class: "text-success"
                            }, "Votre habilitation est en attente de vérification par notre équipe. Vous serez notifié par email dès que votre habilitation sera validée."))
                          ]),
                          _: 1
                        }, 8, ["errors"])
                      ]),
                      createVNode("h2", { class: "text-primary mb-10 text-[1.3rem] font-bold" }, " Pièces justificatives "),
                      createVNode("div", { class: "grid-cols-2 gap-x-10 md:grid" }, [
                        createVNode(_component_FormField, {
                          class: "mb-4",
                          name: "clearance",
                          label: "Habilitation",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            companyData.value.clearance_url ? (openBlock(), createBlock("a", {
                              key: 0,
                              class: "bg-secondary mb-2 flex items-center justify-between gap-3 rounded p-3 px-5 font-bold text-white",
                              href: companyData.value.clearance_url,
                              target: "_blank"
                            }, [
                              createVNode("i", { class: "pi pi-eye" }),
                              createVNode("span", { class: "grow text-center" }, "Voir mon habilitation actuelle")
                            ], 8, ["href"])) : createCommentVNode("", true),
                            companyData.value.clearance ? (openBlock(), createBlock("div", {
                              key: 1,
                              class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                            }, [
                              createVNode("span", { class: "font-normal" }, toDisplayString(companyData.value.clearance.name), 1),
                              createVNode("span", {
                                onClick: ($event2) => companyData.value.clearance = null,
                                class: "cursor-pointer font-normal"
                              }, "Annuler", 8, ["onClick"])
                            ])) : (openBlock(), createBlock(unref(script$1), {
                              key: 2,
                              onUploader: (e) => {
                                companyData.value.clearance = e.files[0];
                              },
                              accept: "application/pdf",
                              name: "clearance",
                              auto: "",
                              mode: "basic",
                              modelValue: companyData.value.clearance,
                              "onUpdate:modelValue": ($event2) => companyData.value.clearance = $event2,
                              class: "w-full",
                              "choose-label": "Mettre à jour mon habilitation",
                              customUpload: true,
                              pt: {
                                chooseButton: { style: "background-color: #96B938 " }
                              },
                              disabled: loading.value
                            }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"])),
                            !unref(company).clearance_need_verification ? (openBlock(), createBlock("small", {
                              key: 3,
                              class: "mt-2"
                            }, "Une modification de ce champ entraînera une vérification de la validité de votre habilitation. Vous ne pourrez plus utiliser la plateforme le temps de la vérification. ")) : (openBlock(), createBlock("small", {
                              key: 4,
                              class: "text-success mt-2"
                            }, "Votre habilitation est en attente de vérification par notre équipe. Vous serez notifié par email dès que votre habilitation sera validée."))
                          ]),
                          _: 1
                        }, 8, ["errors"]),
                        createVNode(_component_FormField, {
                          class: "mb-4",
                          name: "kbis",
                          label: "Extrait Kbis",
                          errors: validationErrors.value
                        }, {
                          default: withCtx(() => [
                            companyData.value.kbis_url ? (openBlock(), createBlock("a", {
                              key: 0,
                              class: "bg-secondary mb-2 flex items-center justify-between gap-3 rounded p-3 px-5 font-bold text-white",
                              href: companyData.value.kbis_url,
                              target: "_blank"
                            }, [
                              createVNode("i", { class: "pi pi-eye" }),
                              createVNode("span", { class: "grow text-center" }, "Voir mon KBIS actuel")
                            ], 8, ["href"])) : createCommentVNode("", true),
                            companyData.value.kbis ? (openBlock(), createBlock("div", {
                              key: 1,
                              class: "bg-ternary-lightest text-primary flex items-center justify-between gap-3 rounded p-3"
                            }, [
                              createVNode("span", { class: "font-normal" }, toDisplayString(companyData.value.kbis.name), 1),
                              createVNode("span", {
                                onClick: ($event2) => companyData.value.kbis = null,
                                class: "cursor-pointer font-normal"
                              }, "Annuler", 8, ["onClick"])
                            ])) : (openBlock(), createBlock(unref(script$1), {
                              key: 2,
                              onUploader: (e) => {
                                companyData.value.kbis = e.files[0];
                              },
                              accept: "application/pdf",
                              name: "kbis",
                              auto: "",
                              mode: "basic",
                              modelValue: companyData.value.kbis,
                              "onUpdate:modelValue": ($event2) => companyData.value.kbis = $event2,
                              class: "w-full",
                              "choose-label": "Mettre à jour mon KBIS",
                              customUpload: true,
                              pt: {
                                chooseButton: { style: "background-color: #96B938 " }
                              },
                              disabled: loading.value
                            }, null, 8, ["onUploader", "modelValue", "onUpdate:modelValue", "disabled"]))
                          ]),
                          _: 1
                        }, 8, ["errors"])
                      ]),
                      createVNode("div", { class: "flex justify-center py-10" }, [
                        createVNode(_component_rounded_button, {
                          loading: loading.value,
                          type: "submit",
                          design: "1",
                          class: "px-[5rem]"
                        }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(loading.value ? "Mise à jour en cours..." : "Mettre à jour"), 1)
                          ]),
                          _: 1
                        }, 8, ["loading"])
                      ])
                    ], 40, ["onSubmit"])) : (openBlock(), createBlock("div", {
                      key: 4,
                      class: "flex items-center justify-center pb-[5rem] pt-[5rem]"
                    }, [
                      createVNode(_component_ProgressSpinner, {
                        style: { "width": "250px", "height": "250px" },
                        pt: {
                          spinner: { style: { animationDuration: "0.5s" } },
                          circle: {
                            style: {
                              stroke: "var(--primary-500)",
                              strokeWidth: 0.3,
                              animation: "none"
                            }
                          }
                        }
                      }, null, 8, ["pt"])
                    ]))
                  ])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$8 = _sfc_main$8.setup;
_sfc_main$8.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/CompanyForm.vue");
  return _sfc_setup$8 ? _sfc_setup$8(props, ctx) : void 0;
};
const __nuxt_component_3 = _sfc_main$8;
const _sfc_main$7 = {
  __name: "VehicleForm",
  __ssrInlineRender: true,
  props: {
    vehicle: {
      type: Object,
      default: () => ({}),
      required: false
    }
  },
  emits: ["updated"],
  setup(__props, { emit }) {
    const props = __props;
    const isEdit = computed(() => {
      return !!props.vehicle.id;
    });
    const vehicleData = ref(null);
    const validationErrors = ref({});
    const loading = ref(false);
    const error2 = ref(null);
    const success = ref(null);
    const typeOptions = ref([
      {
        label: "Transport avant et après mise en bière (Frigorifique)",
        value: "before_coffin"
      },
      { label: "Transport après mise en bière", value: "after_coffin" }
    ]);
    const sizeOptions = ref([
      {
        label: "Standard: dimensions intérieures du cercueil < ou = à 195cm x 60cm",
        value: 1
      },
      {
        label: "Hors-normes: dimensions intérieures du cercueil > à 195cm x l60cm",
        value: 0
      }
    ]);
    watch(
      () => props.vehicle,
      (vehicle) => {
        vehicleData.value = _.cloneDeep(vehicle);
      },
      { immediate: true }
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Message = resolveComponent("Message");
      const _component_FormField = __nuxt_component_5$1;
      const _component_InputText = resolveComponent("InputText");
      const _component_Dropdown = resolveComponent("Dropdown");
      const _component_rounded_button = __nuxt_component_8;
      const _component_icon = __nuxt_component_3$1;
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="text-primary mb-5 text-[1.25rem] font-medium">${ssrInterpolate(unref(isEdit) ? __props.vehicle.name : "Ajouter un véhicule")}</div>`);
      if (unref(vehicleData)) {
        _push(`<form class="${ssrRenderClass(`${unref(isEdit) ? "bg-background-3" : "border-primary border-2 bg-white"} flex flex-col rounded-xl px-10 pb-2 pt-10`)}">`);
        if (unref(error2)) {
          _push(ssrRenderComponent(_component_Message, { severity: "error" }, {
            default: withCtx((_2, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(unref(error2))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(unref(error2)), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        if (unref(success)) {
          _push(ssrRenderComponent(_component_Message, {
            sticky: false,
            life: "3000",
            severity: "success"
          }, {
            default: withCtx((_2, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(unref(success))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(unref(success)), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="mb-5">`);
        _push(ssrRenderComponent(_component_FormField, {
          class: "mb-2 w-full",
          name: "name",
          label: "Nom du véhicule",
          errors: unref(validationErrors)
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="p-input-icon-right"${_scopeId}><i class="pi pi-pencil"${_scopeId}></i>`);
              _push2(ssrRenderComponent(_component_InputText, {
                modelValue: unref(vehicleData).name,
                "onUpdate:modelValue": ($event) => unref(vehicleData).name = $event,
                type: "text",
                placeholder: "Nom du véhicule",
                class: `w-full ${unref(validationErrors).name ? "p-invalid" : ""}`,
                disabled: unref(loading)
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "p-input-icon-right" }, [
                  createVNode("i", { class: "pi pi-pencil" }),
                  createVNode(_component_InputText, {
                    modelValue: unref(vehicleData).name,
                    "onUpdate:modelValue": ($event) => unref(vehicleData).name = $event,
                    type: "text",
                    placeholder: "Nom du véhicule",
                    class: `w-full ${unref(validationErrors).name ? "p-invalid" : ""}`,
                    disabled: unref(loading)
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(_component_FormField, {
          class: "mb-2 w-full",
          name: "type",
          label: "Type de véhicule",
          errors: unref(validationErrors)
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="p-input-icon-right"${_scopeId}><i class="pi pi-pencil"${_scopeId}></i>`);
              _push2(ssrRenderComponent(_component_Dropdown, {
                modelValue: unref(vehicleData).type,
                "onUpdate:modelValue": ($event) => unref(vehicleData).type = $event,
                options: unref(typeOptions),
                optionValue: "value",
                optionLabel: "label",
                placeholder: "Choisir un type de véhicule",
                disabled: unref(loading),
                class: `w-full ${unref(validationErrors).type ? "p-invalid" : ""}`
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "p-input-icon-right" }, [
                  createVNode("i", { class: "pi pi-pencil" }),
                  createVNode(_component_Dropdown, {
                    modelValue: unref(vehicleData).type,
                    "onUpdate:modelValue": ($event) => unref(vehicleData).type = $event,
                    options: unref(typeOptions),
                    optionValue: "value",
                    optionLabel: "label",
                    placeholder: "Choisir un type de véhicule",
                    disabled: unref(loading),
                    class: `w-full ${unref(validationErrors).type ? "p-invalid" : ""}`
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "options", "disabled", "class"])
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(_component_FormField, {
          class: "mb-2 w-full",
          name: "is_standard_size",
          label: "Taille du véhicule",
          errors: unref(validationErrors)
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="p-input-icon-right"${_scopeId}><i class="pi pi-pencil"${_scopeId}></i>`);
              _push2(ssrRenderComponent(_component_Dropdown, {
                modelValue: unref(vehicleData).is_standard_size,
                "onUpdate:modelValue": ($event) => unref(vehicleData).is_standard_size = $event,
                options: unref(sizeOptions),
                optionValue: "value",
                optionLabel: "label",
                placeholder: "Choisir une taille de véhicule",
                disabled: unref(loading),
                class: `w-full ${unref(validationErrors).is_standard_size ? "p-invalid" : ""}`
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "p-input-icon-right" }, [
                  createVNode("i", { class: "pi pi-pencil" }),
                  createVNode(_component_Dropdown, {
                    modelValue: unref(vehicleData).is_standard_size,
                    "onUpdate:modelValue": ($event) => unref(vehicleData).is_standard_size = $event,
                    options: unref(sizeOptions),
                    optionValue: "value",
                    optionLabel: "label",
                    placeholder: "Choisir une taille de véhicule",
                    disabled: unref(loading),
                    class: `w-full ${unref(validationErrors).is_standard_size ? "p-invalid" : ""}`
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "options", "disabled", "class"])
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(_component_FormField, {
          class: "mb-2 w-full",
          name: "license_plate",
          label: "Plaque d'immatriculation",
          errors: unref(validationErrors)
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="p-input-icon-right"${_scopeId}><i class="pi pi-pencil"${_scopeId}></i>`);
              _push2(ssrRenderComponent(_component_InputText, {
                modelValue: unref(vehicleData).license_plate,
                "onUpdate:modelValue": ($event) => unref(vehicleData).license_plate = $event,
                type: "text",
                placeholder: "Plaque d'immatriculation",
                class: `w-full ${unref(validationErrors).license_plate ? "p-invalid" : ""}`,
                disabled: unref(loading)
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "p-input-icon-right" }, [
                  createVNode("i", { class: "pi pi-pencil" }),
                  createVNode(_component_InputText, {
                    modelValue: unref(vehicleData).license_plate,
                    "onUpdate:modelValue": ($event) => unref(vehicleData).license_plate = $event,
                    type: "text",
                    placeholder: "Plaque d'immatriculation",
                    class: `w-full ${unref(validationErrors).license_plate ? "p-invalid" : ""}`,
                    disabled: unref(loading)
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div><div class="mb-5">`);
        if (unref(isEdit)) {
          _push(ssrRenderComponent(_component_rounded_button, {
            loading: unref(loading),
            type: "submit",
            design: "1",
            class: "w-full px-[5rem]"
          }, {
            default: withCtx((_2, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(unref(loading) ? "Mise à jour en cours..." : "Mettre à jour")}`);
              } else {
                return [
                  createTextVNode(toDisplayString(unref(loading) ? "Mise à jour en cours..." : "Mettre à jour"), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(ssrRenderComponent(_component_rounded_button, {
            loading: unref(loading),
            type: "submit",
            design: "1",
            class: "w-full px-[5rem]"
          }, {
            default: withCtx((_2, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(unref(loading) ? "Ajout en cours..." : "Ajouter le véhicule")}`);
              } else {
                return [
                  createTextVNode(toDisplayString(unref(loading) ? "Ajout en cours..." : "Ajouter le véhicule"), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        }
        _push(`</div>`);
        if (unref(isEdit)) {
          _push(`<div class="flex items-center justify-end"><div class="text-primary mb-5 cursor-pointer font-semibold transition-colors hover:text-red-500"> Supprimer le véhicule `);
          _push(ssrRenderComponent(_component_icon, {
            icon: "remove",
            class: "ml-2 h-6 w-6"
          }, null, _parent));
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</form>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup$7 = _sfc_main$7.setup;
_sfc_main$7.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/VehicleForm.vue");
  return _sfc_setup$7 ? _sfc_setup$7(props, ctx) : void 0;
};
const VehicleForm = _sfc_main$7;
const _sfc_main$6 = {
  __name: "VehiclesForm",
  __ssrInlineRender: true,
  setup(__props) {
    const { $api, $toast, $listen, $unListen } = useNuxtApp();
    useAuthStore();
    const vehicles = ref([]);
    const loading = ref(false);
    const success = ref(null);
    const error2 = ref(null);
    async function fetchVehicles() {
      loading.value = true;
      try {
        vehicles.value = await $api.call("get", $api.route("me.vehicles.index"));
      } catch (e) {
        error2.value = e;
        toast.error(
          "Une erreur est survenue lors de la récupération des véhicules"
        );
      } finally {
        loading.value = false;
      }
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_wrapper = __nuxt_component_0$1;
      const _component_section_container = __nuxt_component_1$1;
      const _component_ProgressBar = resolveComponent("ProgressBar");
      const _component_Message = resolveComponent("Message");
      _push(ssrRenderComponent(_component_section_wrapper, mergeProps({ class: "bg-background-3 pb-12" }, _attrs), {
        default: withCtx((_2, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container"
            }, {
              default: withCtx((_3, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="rounded-xl bg-white px-12 py-8"${_scopeId2}><h2 class="text-primary mb-10 text-[1.563rem] font-bold"${_scopeId2}> Mes véhicules </h2>`);
                  if (loading.value) {
                    _push3(ssrRenderComponent(_component_ProgressBar, {
                      mode: "indeterminate",
                      class: "mb-10",
                      style: { "height": "6px" }
                    }, null, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (error2.value) {
                    _push3(ssrRenderComponent(_component_Message, { severity: "error" }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(error2.value)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(error2.value), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (success.value) {
                    _push3(ssrRenderComponent(_component_Message, {
                      sticky: false,
                      life: "3000",
                      severity: "success"
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(success.value)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(success.value), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  _push3(ssrRenderComponent(VehicleForm, {
                    onUpdated: fetchVehicles,
                    class: "mb-10"
                  }, null, _parent3, _scopeId2));
                  if (vehicles.value) {
                    _push3(`<div class="grid-cols-2 gap-10 md:grid"${_scopeId2}><!--[-->`);
                    ssrRenderList(vehicles.value, (vehicle) => {
                      _push3(ssrRenderComponent(VehicleForm, {
                        vehicle,
                        key: vehicle.id,
                        onUpdated: fetchVehicles
                      }, null, _parent3, _scopeId2));
                    });
                    _push3(`<!--]--></div>`);
                  } else {
                    _push3(`<!---->`);
                  }
                  _push3(`</div>`);
                } else {
                  return [
                    createVNode("div", { class: "rounded-xl bg-white px-12 py-8" }, [
                      createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, " Mes véhicules "),
                      loading.value ? (openBlock(), createBlock(_component_ProgressBar, {
                        key: 0,
                        mode: "indeterminate",
                        class: "mb-10",
                        style: { "height": "6px" }
                      })) : createCommentVNode("", true),
                      error2.value ? (openBlock(), createBlock(_component_Message, {
                        key: 1,
                        severity: "error"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(error2.value), 1)
                        ]),
                        _: 1
                      })) : createCommentVNode("", true),
                      success.value ? (openBlock(), createBlock(_component_Message, {
                        key: 2,
                        sticky: false,
                        life: "3000",
                        severity: "success"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(success.value), 1)
                        ]),
                        _: 1
                      })) : createCommentVNode("", true),
                      createVNode(VehicleForm, {
                        onUpdated: fetchVehicles,
                        class: "mb-10"
                      }),
                      vehicles.value ? (openBlock(), createBlock("div", {
                        key: 3,
                        class: "grid-cols-2 gap-10 md:grid"
                      }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(vehicles.value, (vehicle) => {
                          return openBlock(), createBlock(VehicleForm, {
                            vehicle,
                            key: vehicle.id,
                            onUpdated: fetchVehicles
                          }, null, 8, ["vehicle"]);
                        }), 128))
                      ])) : createCommentVNode("", true)
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container"
              }, {
                default: withCtx(() => [
                  createVNode("div", { class: "rounded-xl bg-white px-12 py-8" }, [
                    createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, " Mes véhicules "),
                    loading.value ? (openBlock(), createBlock(_component_ProgressBar, {
                      key: 0,
                      mode: "indeterminate",
                      class: "mb-10",
                      style: { "height": "6px" }
                    })) : createCommentVNode("", true),
                    error2.value ? (openBlock(), createBlock(_component_Message, {
                      key: 1,
                      severity: "error"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(error2.value), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    success.value ? (openBlock(), createBlock(_component_Message, {
                      key: 2,
                      sticky: false,
                      life: "3000",
                      severity: "success"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(success.value), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    createVNode(VehicleForm, {
                      onUpdated: fetchVehicles,
                      class: "mb-10"
                    }),
                    vehicles.value ? (openBlock(), createBlock("div", {
                      key: 3,
                      class: "grid-cols-2 gap-10 md:grid"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(vehicles.value, (vehicle) => {
                        return openBlock(), createBlock(VehicleForm, {
                          vehicle,
                          key: vehicle.id,
                          onUpdated: fetchVehicles
                        }, null, 8, ["vehicle"]);
                      }), 128))
                    ])) : createCommentVNode("", true)
                  ])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$6 = _sfc_main$6.setup;
_sfc_main$6.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/VehiclesForm.vue");
  return _sfc_setup$6 ? _sfc_setup$6(props, ctx) : void 0;
};
const __nuxt_component_4 = _sfc_main$6;
const _sfc_main$5 = {
  __name: "OperatorForm",
  __ssrInlineRender: true,
  props: {
    operator: {
      type: Object,
      default: () => ({}),
      required: false
    }
  },
  emits: ["updated"],
  setup(__props, { emit }) {
    const props = __props;
    const isEdit = computed(() => {
      return !!props.operator.id;
    });
    const operatorData = ref(null);
    const validationErrors = ref({});
    const loading = ref(false);
    const error2 = ref(null);
    const success = ref(null);
    watch(
      () => props.operator,
      (operator) => {
        operatorData.value = _.cloneDeep(operator);
      },
      { immediate: true }
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Message = resolveComponent("Message");
      const _component_FormField = __nuxt_component_5$1;
      const _component_InputText = resolveComponent("InputText");
      const _component_InputMask = resolveComponent("InputMask");
      const _component_rounded_button = __nuxt_component_8;
      const _component_icon = __nuxt_component_3$1;
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="text-primary mb-5 text-[1.25rem] font-medium">${ssrInterpolate(unref(isEdit) ? __props.operator.name : "Ajouter un chauffeur")}</div>`);
      if (unref(operatorData)) {
        _push(`<form class="${ssrRenderClass(`${unref(isEdit) ? "bg-background-3" : "border-primary border-2 bg-white"} flex flex-col rounded-xl px-10 pb-2 pt-10`)}">`);
        if (unref(error2)) {
          _push(ssrRenderComponent(_component_Message, { severity: "error" }, {
            default: withCtx((_2, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(unref(error2))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(unref(error2)), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        if (unref(success)) {
          _push(ssrRenderComponent(_component_Message, {
            sticky: false,
            life: "3000",
            severity: "success"
          }, {
            default: withCtx((_2, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(unref(success))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(unref(success)), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="mb-5">`);
        _push(ssrRenderComponent(_component_FormField, {
          class: "mb-2 w-full",
          name: "identifier",
          label: "Identifiant",
          errors: unref(validationErrors)
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="p-input-icon-right"${_scopeId}><i class="pi pi-pencil"${_scopeId}></i>`);
              _push2(ssrRenderComponent(_component_InputText, {
                modelValue: unref(operatorData).identifier,
                "onUpdate:modelValue": ($event) => unref(operatorData).identifier = $event,
                type: "text",
                placeholder: "Identifiant",
                class: `w-full ${unref(validationErrors).identifier ? "p-invalid" : ""}`,
                disabled: unref(loading)
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "p-input-icon-right" }, [
                  createVNode("i", { class: "pi pi-pencil" }),
                  createVNode(_component_InputText, {
                    modelValue: unref(operatorData).identifier,
                    "onUpdate:modelValue": ($event) => unref(operatorData).identifier = $event,
                    type: "text",
                    placeholder: "Identifiant",
                    class: `w-full ${unref(validationErrors).identifier ? "p-invalid" : ""}`,
                    disabled: unref(loading)
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(_component_FormField, {
          class: "mb-2 w-full",
          name: "phone",
          label: "Téléphone mobile",
          errors: unref(validationErrors)
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="p-input-icon-right"${_scopeId}><i class="pi pi-mobile"${_scopeId}></i>`);
              _push2(ssrRenderComponent(_component_InputMask, {
                modelValue: unref(operatorData).phone,
                "onUpdate:modelValue": ($event) => unref(operatorData).phone = $event,
                mask: "99 99 99 99 99",
                placeholder: "Téléphone mobile",
                class: `w-full ${unref(validationErrors).phone ? "p-invalid" : ""}`,
                disabled: unref(loading)
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "p-input-icon-right" }, [
                  createVNode("i", { class: "pi pi-mobile" }),
                  createVNode(_component_InputMask, {
                    modelValue: unref(operatorData).phone,
                    "onUpdate:modelValue": ($event) => unref(operatorData).phone = $event,
                    mask: "99 99 99 99 99",
                    placeholder: "Téléphone mobile",
                    class: `w-full ${unref(validationErrors).phone ? "p-invalid" : ""}`,
                    disabled: unref(loading)
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "class", "disabled"])
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div><div class="mb-5">`);
        if (unref(isEdit)) {
          _push(ssrRenderComponent(_component_rounded_button, {
            loading: unref(loading),
            type: "submit",
            design: "1",
            class: "w-full px-[5rem]"
          }, {
            default: withCtx((_2, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(unref(loading) ? "Mise à jour en cours..." : "Mettre à jour")}`);
              } else {
                return [
                  createTextVNode(toDisplayString(unref(loading) ? "Mise à jour en cours..." : "Mettre à jour"), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(ssrRenderComponent(_component_rounded_button, {
            loading: unref(loading),
            type: "submit",
            design: "1",
            class: "w-full px-[5rem]"
          }, {
            default: withCtx((_2, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(unref(loading) ? "Ajout en cours..." : "Ajouter le chauffeur")}`);
              } else {
                return [
                  createTextVNode(toDisplayString(unref(loading) ? "Ajout en cours..." : "Ajouter le chauffeur"), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
        }
        _push(`</div>`);
        if (unref(isEdit)) {
          _push(`<div class="flex items-center justify-end"><div class="text-primary mb-5 cursor-pointer font-semibold transition-colors hover:text-red-500"> Supprimer le chauffeur `);
          _push(ssrRenderComponent(_component_icon, {
            icon: "remove",
            class: "ml-2 h-6 w-6"
          }, null, _parent));
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</form>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/OperatorForm.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const OperatorForm = _sfc_main$5;
const _sfc_main$4 = {
  __name: "OperatorsForm",
  __ssrInlineRender: true,
  setup(__props) {
    const { $api, $toast, $listen, $unListen } = useNuxtApp();
    useAuthStore();
    const operators = ref([]);
    const loading = ref(false);
    const success = ref(null);
    const error2 = ref(null);
    async function fetchOperators() {
      loading.value = true;
      try {
        operators.value = await $api.call("get", $api.route("me.operators.index"));
      } catch (e) {
        error2.value = e;
        $toast.error(
          "Une erreur est survenue lors de la récupération des chauffeurs."
        );
      } finally {
        loading.value = false;
      }
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_wrapper = __nuxt_component_0$1;
      const _component_section_container = __nuxt_component_1$1;
      const _component_ProgressBar = resolveComponent("ProgressBar");
      const _component_Message = resolveComponent("Message");
      _push(ssrRenderComponent(_component_section_wrapper, mergeProps({ class: "bg-background-3 pb-12" }, _attrs), {
        default: withCtx((_2, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container"
            }, {
              default: withCtx((_3, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="rounded-xl bg-white px-12 py-8"${_scopeId2}><h2 class="text-primary mb-10 text-[1.563rem] font-bold"${_scopeId2}> Mes chauffeurs </h2>`);
                  if (loading.value) {
                    _push3(ssrRenderComponent(_component_ProgressBar, {
                      mode: "indeterminate",
                      class: "mb-10",
                      style: { "height": "6px" }
                    }, null, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (error2.value) {
                    _push3(ssrRenderComponent(_component_Message, { severity: "error" }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(error2.value)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(error2.value), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (success.value) {
                    _push3(ssrRenderComponent(_component_Message, {
                      sticky: false,
                      life: "3000",
                      severity: "success"
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(success.value)}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(success.value), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  _push3(ssrRenderComponent(OperatorForm, {
                    onUpdated: fetchOperators,
                    class: "mb-10"
                  }, null, _parent3, _scopeId2));
                  if (operators.value) {
                    _push3(`<div class="grid-cols-2 gap-10 md:grid"${_scopeId2}><!--[-->`);
                    ssrRenderList(operators.value, (operator) => {
                      _push3(ssrRenderComponent(OperatorForm, {
                        operator,
                        key: operator.id,
                        onUpdated: fetchOperators
                      }, null, _parent3, _scopeId2));
                    });
                    _push3(`<!--]--></div>`);
                  } else {
                    _push3(`<!---->`);
                  }
                  _push3(`</div>`);
                } else {
                  return [
                    createVNode("div", { class: "rounded-xl bg-white px-12 py-8" }, [
                      createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, " Mes chauffeurs "),
                      loading.value ? (openBlock(), createBlock(_component_ProgressBar, {
                        key: 0,
                        mode: "indeterminate",
                        class: "mb-10",
                        style: { "height": "6px" }
                      })) : createCommentVNode("", true),
                      error2.value ? (openBlock(), createBlock(_component_Message, {
                        key: 1,
                        severity: "error"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(error2.value), 1)
                        ]),
                        _: 1
                      })) : createCommentVNode("", true),
                      success.value ? (openBlock(), createBlock(_component_Message, {
                        key: 2,
                        sticky: false,
                        life: "3000",
                        severity: "success"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(success.value), 1)
                        ]),
                        _: 1
                      })) : createCommentVNode("", true),
                      createVNode(OperatorForm, {
                        onUpdated: fetchOperators,
                        class: "mb-10"
                      }),
                      operators.value ? (openBlock(), createBlock("div", {
                        key: 3,
                        class: "grid-cols-2 gap-10 md:grid"
                      }, [
                        (openBlock(true), createBlock(Fragment, null, renderList(operators.value, (operator) => {
                          return openBlock(), createBlock(OperatorForm, {
                            operator,
                            key: operator.id,
                            onUpdated: fetchOperators
                          }, null, 8, ["operator"]);
                        }), 128))
                      ])) : createCommentVNode("", true)
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container"
              }, {
                default: withCtx(() => [
                  createVNode("div", { class: "rounded-xl bg-white px-12 py-8" }, [
                    createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, " Mes chauffeurs "),
                    loading.value ? (openBlock(), createBlock(_component_ProgressBar, {
                      key: 0,
                      mode: "indeterminate",
                      class: "mb-10",
                      style: { "height": "6px" }
                    })) : createCommentVNode("", true),
                    error2.value ? (openBlock(), createBlock(_component_Message, {
                      key: 1,
                      severity: "error"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(error2.value), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    success.value ? (openBlock(), createBlock(_component_Message, {
                      key: 2,
                      sticky: false,
                      life: "3000",
                      severity: "success"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(success.value), 1)
                      ]),
                      _: 1
                    })) : createCommentVNode("", true),
                    createVNode(OperatorForm, {
                      onUpdated: fetchOperators,
                      class: "mb-10"
                    }),
                    operators.value ? (openBlock(), createBlock("div", {
                      key: 3,
                      class: "grid-cols-2 gap-10 md:grid"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(operators.value, (operator) => {
                        return openBlock(), createBlock(OperatorForm, {
                          operator,
                          key: operator.id,
                          onUpdated: fetchOperators
                        }, null, 8, ["operator"]);
                      }), 128))
                    ])) : createCommentVNode("", true)
                  ])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/OperatorsForm.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const __nuxt_component_5 = _sfc_main$4;
const _sfc_main$3 = {
  __name: "StripeAccount",
  __ssrInlineRender: true,
  setup(__props) {
    const { company } = useAuthStore();
    const { $api, $toast } = useNuxtApp();
    const redirecting = ref(false);
    const getDashboardUrl = () => {
      redirecting.value = true;
      return $api.call("get", $api.route("me.stripe-dashboard-link")).then((payload) => {
        window.location.href = payload.url;
      }).catch((e) => {
        if (e.response) {
          if (e.response.data.message) {
            $toast.error(e.response.data.message);
          } else {
            if (e.response.data.error) {
              $toast.error(e.response.data.error);
            }
          }
        }
      }).finally(() => {
        redirecting.value = false;
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_wrapper = __nuxt_component_0$1;
      const _component_section_container = __nuxt_component_1$1;
      const _component_Message = resolveComponent("Message");
      const _component_rounded_button = __nuxt_component_8;
      _push(ssrRenderComponent(_component_section_wrapper, mergeProps({ class: "bg-background-3 pb-12" }, _attrs), {
        default: withCtx((_2, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container"
            }, {
              default: withCtx((_3, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<h2 class="text-primary mb-10 text-[1.563rem] font-bold"${_scopeId2}> Mon compte Stripe </h2>`);
                  if (unref(company).has_stripe_account && unref(company).onboarding_completed) {
                    _push3(`<div${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_Message, {
                      sticky: true,
                      severity: "success",
                      closable: false
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`Votre compte Stripe est actif. `);
                        } else {
                          return [
                            createTextVNode("Votre compte Stripe est actif. ")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_rounded_button, {
                      class: "w-full",
                      onClick: getDashboardUrl,
                      design: "3",
                      target: "_blank"
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(unref(redirecting) ? "Redirection..." : "Mon dashboard Stripe")}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(unref(redirecting) ? "Redirection..." : "Mon dashboard Stripe"), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`</div>`);
                  } else {
                    _push3(ssrRenderComponent(_component_Message, {
                      sticky: true,
                      severity: "info",
                      closable: false
                    }, {
                      default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`Votre compte Stripe n&#39;est pas encore créé (Voir message en haut de page)`);
                        } else {
                          return [
                            createTextVNode("Votre compte Stripe n'est pas encore créé (Voir message en haut de page)")
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  }
                } else {
                  return [
                    createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, " Mon compte Stripe "),
                    unref(company).has_stripe_account && unref(company).onboarding_completed ? (openBlock(), createBlock("div", { key: 0 }, [
                      createVNode(_component_Message, {
                        sticky: true,
                        severity: "success",
                        closable: false
                      }, {
                        default: withCtx(() => [
                          createTextVNode("Votre compte Stripe est actif. ")
                        ]),
                        _: 1
                      }),
                      createVNode(_component_rounded_button, {
                        class: "w-full",
                        onClick: getDashboardUrl,
                        design: "3",
                        target: "_blank"
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(unref(redirecting) ? "Redirection..." : "Mon dashboard Stripe"), 1)
                        ]),
                        _: 1
                      })
                    ])) : (openBlock(), createBlock(_component_Message, {
                      key: 1,
                      sticky: true,
                      severity: "info",
                      closable: false
                    }, {
                      default: withCtx(() => [
                        createTextVNode("Votre compte Stripe n'est pas encore créé (Voir message en haut de page)")
                      ]),
                      _: 1
                    }))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container"
              }, {
                default: withCtx(() => [
                  createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, " Mon compte Stripe "),
                  unref(company).has_stripe_account && unref(company).onboarding_completed ? (openBlock(), createBlock("div", { key: 0 }, [
                    createVNode(_component_Message, {
                      sticky: true,
                      severity: "success",
                      closable: false
                    }, {
                      default: withCtx(() => [
                        createTextVNode("Votre compte Stripe est actif. ")
                      ]),
                      _: 1
                    }),
                    createVNode(_component_rounded_button, {
                      class: "w-full",
                      onClick: getDashboardUrl,
                      design: "3",
                      target: "_blank"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(unref(redirecting) ? "Redirection..." : "Mon dashboard Stripe"), 1)
                      ]),
                      _: 1
                    })
                  ])) : (openBlock(), createBlock(_component_Message, {
                    key: 1,
                    sticky: true,
                    severity: "info",
                    closable: false
                  }, {
                    default: withCtx(() => [
                      createTextVNode("Votre compte Stripe n'est pas encore créé (Voir message en haut de page)")
                    ]),
                    _: 1
                  }))
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/StripeAccount.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const __nuxt_component_6 = _sfc_main$3;
const _sfc_main$2 = {
  __name: "ManagePaymentMethod",
  __ssrInlineRender: true,
  setup(__props) {
    const { $api } = useNuxtApp();
    const redirecting = ref(false);
    const getPortalUrl = () => {
      redirecting.value = true;
      return $api.call("get", $api.route("me.manage-payment-methods-link")).then((payload) => {
        window.open(payload.url);
      }).catch((err) => {
        error.value = "Une erreur est survenue lors de la redirection vers le portail de gestion de methodes de paiement";
      }).finally(() => {
        redirecting.value = false;
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_section_wrapper = __nuxt_component_0$1;
      const _component_section_container = __nuxt_component_1$1;
      const _component_Message = resolveComponent("Message");
      const _component_rounded_button = __nuxt_component_8;
      _push(ssrRenderComponent(_component_section_wrapper, mergeProps({ class: "bg-background-3 pb-12" }, _attrs), {
        default: withCtx((_2, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_section_container, {
              "mobile-padding": "",
              class: "max-w-container"
            }, {
              default: withCtx((_3, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<h2 class="text-primary mb-10 text-[1.563rem] font-bold"${_scopeId2}> Mes méthodes de paiement </h2>`);
                  _push3(ssrRenderComponent(_component_Message, { severity: "info" }, {
                    default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(` Le bouton ci-dessous vous redirigera vers le portail de gestion de vos méthodes de paiement chez notre partenaire Stripe.<br${_scopeId3}> Vous pourrez y ajouter, modifier ou supprimer des cartes bancaires et sélectionner une méthode de paiement par défaut. `);
                      } else {
                        return [
                          createTextVNode(" Le bouton ci-dessous vous redirigera vers le portail de gestion de vos méthodes de paiement chez notre partenaire Stripe."),
                          createVNode("br"),
                          createTextVNode(" Vous pourrez y ajouter, modifier ou supprimer des cartes bancaires et sélectionner une méthode de paiement par défaut. ")
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_rounded_button, {
                    class: "w-full",
                    onClick: getPortalUrl,
                    design: "3",
                    target: "_blank"
                  }, {
                    default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`${ssrInterpolate(unref(redirecting) ? "Redirection..." : "Gérer mes méthodes de paiement")}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(unref(redirecting) ? "Redirection..." : "Gérer mes méthodes de paiement"), 1)
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, " Mes méthodes de paiement "),
                    createVNode(_component_Message, { severity: "info" }, {
                      default: withCtx(() => [
                        createTextVNode(" Le bouton ci-dessous vous redirigera vers le portail de gestion de vos méthodes de paiement chez notre partenaire Stripe."),
                        createVNode("br"),
                        createTextVNode(" Vous pourrez y ajouter, modifier ou supprimer des cartes bancaires et sélectionner une méthode de paiement par défaut. ")
                      ]),
                      _: 1
                    }),
                    createVNode(_component_rounded_button, {
                      class: "w-full",
                      onClick: getPortalUrl,
                      design: "3",
                      target: "_blank"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(unref(redirecting) ? "Redirection..." : "Gérer mes méthodes de paiement"), 1)
                      ]),
                      _: 1
                    })
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_section_container, {
                "mobile-padding": "",
                class: "max-w-container"
              }, {
                default: withCtx(() => [
                  createVNode("h2", { class: "text-primary mb-10 text-[1.563rem] font-bold" }, " Mes méthodes de paiement "),
                  createVNode(_component_Message, { severity: "info" }, {
                    default: withCtx(() => [
                      createTextVNode(" Le bouton ci-dessous vous redirigera vers le portail de gestion de vos méthodes de paiement chez notre partenaire Stripe."),
                      createVNode("br"),
                      createTextVNode(" Vous pourrez y ajouter, modifier ou supprimer des cartes bancaires et sélectionner une méthode de paiement par défaut. ")
                    ]),
                    _: 1
                  }),
                  createVNode(_component_rounded_button, {
                    class: "w-full",
                    onClick: getPortalUrl,
                    design: "3",
                    target: "_blank"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(unref(redirecting) ? "Redirection..." : "Gérer mes méthodes de paiement"), 1)
                    ]),
                    _: 1
                  })
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/ManagePaymentMethod.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const __nuxt_component_7 = _sfc_main$2;
const _sfc_main$1 = {
  props: {
    anchors: {
      type: Array,
      default: () => []
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_section_container = __nuxt_component_1$1;
  const _component_NuxtLink = __nuxt_component_0$2;
  const _component_icon = __nuxt_component_3$1;
  _push(ssrRenderComponent(_component_section_container, mergeProps({
    "mobile-padding": "",
    class: "max-w-container pt-8 max-xl:text-center max-lg:pb-8"
  }, _attrs), {
    default: withCtx((_2, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(`<div class="bg-white"${_scopeId}>`);
        _push2(ssrRenderComponent(_component_section_container, { class: "max-w-container relative z-[1] flex max-lg:flex-col" }, {
          default: withCtx((_3, _push3, _parent3, _scopeId2) => {
            if (_push3) {
              _push3(`<!--[-->`);
              ssrRenderList($props.anchors, (anchor) => {
                _push3(ssrRenderComponent(_component_NuxtLink, {
                  key: anchor.id,
                  to: `#${anchor.id}`,
                  class: `text-neutral-lighter hover:text-primary border-primary group relative flex grow cursor-pointer py-5 pl-5 pr-16 font-semibold transition-colors lg:whitespace-pre`
                }, {
                  default: withCtx((_4, _push4, _parent4, _scopeId3) => {
                    if (_push4) {
                      _push4(ssrRenderComponent(_component_icon, {
                        icon: anchor.icon,
                        class: "mr-5 h-6 w-5"
                      }, null, _parent4, _scopeId3));
                      _push4(` ${ssrInterpolate(anchor.title)} <div class="${ssrRenderClass(`bg-primary transition-width absolute bottom-0 left-0 right-0 mx-auto h-[3px] w-0 group-hover:w-full max-lg:hidden`)}"${_scopeId3}></div>`);
                    } else {
                      return [
                        createVNode(_component_icon, {
                          icon: anchor.icon,
                          class: "mr-5 h-6 w-5"
                        }, null, 8, ["icon"]),
                        createTextVNode(" " + toDisplayString(anchor.title) + " ", 1),
                        createVNode("div", { class: `bg-primary transition-width absolute bottom-0 left-0 right-0 mx-auto h-[3px] w-0 group-hover:w-full max-lg:hidden` })
                      ];
                    }
                  }),
                  _: 2
                }, _parent3, _scopeId2));
              });
              _push3(`<!--]-->`);
            } else {
              return [
                (openBlock(true), createBlock(Fragment, null, renderList($props.anchors, (anchor) => {
                  return openBlock(), createBlock(_component_NuxtLink, {
                    key: anchor.id,
                    to: `#${anchor.id}`,
                    class: `text-neutral-lighter hover:text-primary border-primary group relative flex grow cursor-pointer py-5 pl-5 pr-16 font-semibold transition-colors lg:whitespace-pre`
                  }, {
                    default: withCtx(() => [
                      createVNode(_component_icon, {
                        icon: anchor.icon,
                        class: "mr-5 h-6 w-5"
                      }, null, 8, ["icon"]),
                      createTextVNode(" " + toDisplayString(anchor.title) + " ", 1),
                      createVNode("div", { class: `bg-primary transition-width absolute bottom-0 left-0 right-0 mx-auto h-[3px] w-0 group-hover:w-full max-lg:hidden` })
                    ]),
                    _: 2
                  }, 1032, ["to"]);
                }), 128))
              ];
            }
          }),
          _: 1
        }, _parent2, _scopeId));
        _push2(`</div>`);
        ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
      } else {
        return [
          createVNode("div", { class: "bg-white" }, [
            createVNode(_component_section_container, { class: "max-w-container relative z-[1] flex max-lg:flex-col" }, {
              default: withCtx(() => [
                (openBlock(true), createBlock(Fragment, null, renderList($props.anchors, (anchor) => {
                  return openBlock(), createBlock(_component_NuxtLink, {
                    key: anchor.id,
                    to: `#${anchor.id}`,
                    class: `text-neutral-lighter hover:text-primary border-primary group relative flex grow cursor-pointer py-5 pl-5 pr-16 font-semibold transition-colors lg:whitespace-pre`
                  }, {
                    default: withCtx(() => [
                      createVNode(_component_icon, {
                        icon: anchor.icon,
                        class: "mr-5 h-6 w-5"
                      }, null, 8, ["icon"]),
                      createTextVNode(" " + toDisplayString(anchor.title) + " ", 1),
                      createVNode("div", { class: `bg-primary transition-width absolute bottom-0 left-0 right-0 mx-auto h-[3px] w-0 group-hover:w-full max-lg:hidden` })
                    ]),
                    _: 2
                  }, 1032, ["to"]);
                }), 128))
              ]),
              _: 1
            })
          ]),
          renderSlot(_ctx.$slots, "default")
        ];
      }
    }),
    _: 3
  }, _parent));
}
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/AnchorMenu.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const AnchorMenu = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["ssrRender", _sfc_ssrRender]]);
const _sfc_main = {
  __name: "index",
  __ssrInlineRender: true,
  setup(__props) {
    const anchors = [
      {
        title: "Mon compte",
        icon: "profil",
        id: "mon-compte"
      },
      {
        title: "Ma société",
        icon: "mes-info",
        id: "ma-societe"
      },
      {
        title: "Mes véhicules",
        icon: "voiture",
        id: "mes-vehicules"
      },
      {
        title: "Mes chauffeurs",
        icon: "operateur",
        id: "mes-operateurs"
      }
    ];
    return (_ctx, _push, _parent, _attrs) => {
      const _component_AccountMessages = __nuxt_component_0;
      const _component_Statistics = __nuxt_component_1;
      const _component_MeForm = __nuxt_component_2;
      const _component_CompanyForm = __nuxt_component_3;
      const _component_VehiclesForm = __nuxt_component_4;
      const _component_OperatorsForm = __nuxt_component_5;
      const _component_StripeAccount = __nuxt_component_6;
      const _component_ManagePaymentMethod = __nuxt_component_7;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(AnchorMenu, { anchors }, {
        default: withCtx((_2, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_AccountMessages, null, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_AccountMessages)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Statistics, null, null, _parent));
      _push(ssrRenderComponent(_component_MeForm, { id: "mon-compte" }, null, _parent));
      _push(ssrRenderComponent(_component_CompanyForm, { id: "ma-societe" }, null, _parent));
      _push(ssrRenderComponent(_component_VehiclesForm, { id: "mes-vehicules" }, null, _parent));
      _push(ssrRenderComponent(_component_OperatorsForm, { id: "mes-operateurs" }, null, _parent));
      _push(ssrRenderComponent(_component_StripeAccount, null, null, _parent));
      _push(ssrRenderComponent(_component_ManagePaymentMethod, null, null, _parent));
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("pages/dashboard/index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
//# sourceMappingURL=index-085191d4.js.map
