import { createVNode, resolveDynamicComponent, mergeProps, withCtx, renderSlot, useSSRContext } from "vue";
import { ssrRenderVNode, ssrRenderSlot } from "vue/server-renderer";
import { _ as _export_sfc } from "../server.mjs";
const _sfc_main = {
  props: {
    heading: {
      type: String,
      default: "h1"
    },
    invert: {
      type: Boolean,
      default: false
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  ssrRenderVNode(_push, createVNode(resolveDynamicComponent($props.heading), mergeProps({
    class: `${$props.invert ? "text-white" : "text-primary"} text-[1.875rem] font-bold leading-[2.5rem]`
  }, _attrs), {
    default: withCtx((_, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(`<span class="bg-secondary mr-3 inline-block h-3 w-3 rounded-full"${_scopeId}></span>`);
        ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
        _push2(`<span class="bg-ternary ml-3 inline-block h-3 w-3 rounded-full"${_scopeId}></span>`);
      } else {
        return [
          createVNode("span", { class: "bg-secondary mr-3 inline-block h-3 w-3 rounded-full" }),
          renderSlot(_ctx.$slots, "default"),
          createVNode("span", { class: "bg-ternary ml-3 inline-block h-3 w-3 rounded-full" })
        ];
      }
    }),
    _: 3
  }), _parent);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/SectionTitle.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_0 = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  __nuxt_component_0 as _
};
//# sourceMappingURL=SectionTitle-2692cd9d.js.map
