import { _ as __nuxt_component_3 } from "./Icon-7157bd57.js";
import { _ as __nuxt_component_8 } from "./RoundedButton-a0ea68b9.js";
import { v4 } from "uuid";
import { mergeProps, useSSRContext, ref, computed, resolveComponent, unref, withCtx, createTextVNode, toDisplayString } from "vue";
import { ssrRenderAttrs, ssrRenderAttr, ssrRenderClass, ssrInterpolate, ssrRenderList, ssrRenderComponent } from "vue/server-renderer";
import { _ as _export_sfc, n as useRouter, a as useNuxtApp } from "../server.mjs";
import { u as useDayjs } from "./dayjs-9d0b29d3.js";
import "destr";
import "devalue";
import "klona";
import _ from "lodash";
const _sfc_main$1 = {
  props: {
    label: {
      type: String,
      default: "",
      required: true
    },
    color: {
      type: String,
      default: "primary",
      required: true
    },
    options: {
      type: Array,
      default: [{ value: "value1", text: "Value 1" }],
      required: true
    }
  },
  data() {
    return {
      id: v4()
    };
  },
  computed: {
    color() {
      return "text-" + this.color;
    },
    focusColor() {
      return "focus:border-" + this.color;
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "font-medium" }, _attrs))}><label${ssrRenderAttr("for", $data.id)} class="${ssrRenderClass(`${$options.color} mb-1 block text-[0.813rem]`)}">${ssrInterpolate($props.label)}</label><select${ssrRenderAttr("id", $data.id)} class="${ssrRenderClass(`block w-full rounded-md border border-gray-300 bg-white p-2.5 text-[0.813rem] font-medium ${$options.color} ${$options.focusColor} focus:outline-none`)}"><!--[-->`);
  ssrRenderList($props.options, (option) => {
    _push(`<option${ssrRenderAttr("value", option.value)}>${ssrInterpolate(option.text)}</option>`);
  });
  _push(`<!--]--></select></div>`);
}
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/FormSelect.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const __nuxt_component_12 = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["ssrRender", _sfc_ssrRender]]);
const SearchForm_vue_vue_type_style_index_0_lang = "";
const _sfc_main = {
  __name: "SearchForm",
  __ssrInlineRender: true,
  props: {
    // Définissez vos props ici
    advanced: {
      type: Boolean,
      default: false
    },
    originId: {
      type: Number
    },
    destinationId: {
      type: Number
    },
    dateInput: {
      type: Date
    }
  },
  emits: ["search"],
  setup(__props, { expose: __expose, emit }) {
    const props = __props;
    const dayjs = useDayjs();
    const { $api, $toast } = useNuxtApp();
    useRouter();
    const startId = ref(v4());
    const endId = ref(v4());
    const dateId = ref(v4());
    const origin = ref();
    const destination = ref();
    const destinationAutocomplete = ref([]);
    const originAutocomplete = ref([]);
    const date = ref();
    const fetchingDestinationCities = ref(false);
    const fetchingOriginCities = ref(false);
    const updateFields = () => {
      let promises = [];
      if (props.originId) {
        promises.push(
          getCityById(props.originId).then((result) => {
            origin.value = result;
          }).catch(() => {
            $toast.error("Une erreur est survenue");
          })
        );
      }
      if (props.destinationId) {
        promises.push(
          getCityById(props.destinationId).then((result) => {
            destination.value = result;
          }).catch(() => {
            $toast.error("Une erreur est survenue");
          })
        );
      }
      if (props.dateInput) {
        date.value = dayjs(props.dateInput).toDate();
      }
      return Promise.all(promises).then(() => {
        emit("initSearch", {
          destination: destination.value,
          origin: origin.value
        });
      });
    };
    const formValid = computed(() => {
      return origin.value && destination.value && date.value && (dayjs(date.value).isSame(dayjs(), "day") || dayjs(date.value).isAfter(dayjs(), "day"));
    });
    const searchOriginCities = _.debounce((searchQuery) => {
      fetchingOriginCities.value = true;
      autocompleteCityRequest(searchQuery.query).then((result) => {
        originAutocomplete.value = result;
      }).finally(() => {
        fetchingOriginCities.value = false;
      });
    }, 300);
    const searchDestinationCities = _.debounce((searchQuery) => {
      fetchingDestinationCities.value = true;
      autocompleteCityRequest(searchQuery.query).then((result) => {
        destinationAutocomplete.value = result;
      }).finally(() => {
        fetchingDestinationCities.value = false;
      });
    }, 300);
    const autocompleteCityRequest = (input) => {
      if (!input) {
        return [];
      }
      return $api.call("get", $api.route("cities.index"), null, {
        q: input
      }).then((data) => {
        return data;
      }).catch((error) => {
        console.error(error);
        return [];
      });
    };
    const getCityById = (id) => {
      return $api.call("get", $api.route("cities.show", { city: id })).then((payload) => {
        return payload;
      }).catch((err) => {
        console.log(err);
      }).finally(() => {
      });
    };
    __expose({
      updateFields
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_icon = __nuxt_component_3;
      const _component_AutoComplete = resolveComponent("AutoComplete");
      const _component_Calendar = resolveComponent("Calendar");
      const _component_rounded_button = __nuxt_component_8;
      const _component_form_select = __nuxt_component_12;
      _push(`<form${ssrRenderAttrs(mergeProps({
        class: `${__props.advanced ? "rounded-3xl" : "rounded-3xl md:rounded-[3rem]"}    bg-white `
      }, _attrs))}><div class="${ssrRenderClass(`border-neutral-lighter flex items-center  border-dotted text-left max-md:flex-wrap md:px-3 ${__props.advanced ? "md:border-b-2" : ""}`)}"><div class="border-neutral-lighter w-full border-dotted px-8 py-4 max-md:border-b-2 md:border-r-2"><label${ssrRenderAttr("for", startId.value)} class="text-secondary w-full cursor-pointer">Départ</label><div class="text-secondary flex items-center">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "pin-2",
        class: "mr-2 h-4 w-4"
      }, null, _parent));
      _push(ssrRenderComponent(_component_AutoComplete, {
        class: "search-form-text-input",
        forceSelection: "",
        placeholder: "Départ à",
        modelValue: origin.value,
        "onUpdate:modelValue": ($event) => origin.value = $event,
        optionLabel: (o) => `${o.name} (${o.zip_code})`,
        suggestions: originAutocomplete.value,
        onComplete: unref(searchOriginCities)
      }, {
        option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(slotProps.option.name)} (${ssrInterpolate(slotProps.option.zip_code)}) `);
          } else {
            return [
              createTextVNode(toDisplayString(slotProps.option.name) + " (" + toDisplayString(slotProps.option.zip_code) + ") ", 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div><div class="border-neutral-lighter w-full border-dotted px-8 py-4 max-md:border-b-2 md:border-r-2"><label${ssrRenderAttr("for", endId.value)} class="text-ternary w-full cursor-pointer">Destination</label><div class="text-ternary flex items-center">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "pin-2",
        class: "mr-2 h-4 w-4"
      }, null, _parent));
      _push(ssrRenderComponent(_component_AutoComplete, {
        class: "search-form-text-input",
        forceSelection: "",
        placeholder: "Arrivée à",
        modelValue: destination.value,
        "onUpdate:modelValue": ($event) => destination.value = $event,
        optionLabel: (o) => `${o.name} (${o.zip_code})`,
        suggestions: destinationAutocomplete.value,
        onComplete: unref(searchDestinationCities)
      }, {
        option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(slotProps.option.name)} (${ssrInterpolate(slotProps.option.zip_code)}) `);
          } else {
            return [
              createTextVNode(toDisplayString(slotProps.option.name) + " (" + toDisplayString(slotProps.option.zip_code) + ") ", 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div><div class="border-neutral-lighter w-full border-dotted px-8 py-4 max-md:border-b-2"><label${ssrRenderAttr("for", dateId.value)} class="text-fire w-full cursor-pointer">Date</label><div class="text-fire flex items-center">`);
      _push(ssrRenderComponent(_component_icon, {
        icon: "calendrier",
        class: "mr-2 h-4 w-4"
      }, null, _parent));
      _push(ssrRenderComponent(_component_Calendar, {
        dateFormat: "dd/mm/yy",
        modelValue: date.value,
        "onUpdate:modelValue": ($event) => date.value = $event,
        class: "search-form-text-input",
        placeholder: "Date de départ"
      }, null, _parent));
      _push(`</div></div>`);
      if (!__props.advanced) {
        _push(`<div class="max-md:w-full max-md:px-5 max-md:py-8 max-md:text-center">`);
        _push(ssrRenderComponent(_component_rounded_button, {
          class: "max-md:mx-auto max-md:px-12",
          icon: "loupe",
          design: "3",
          type: "submit",
          size: "lg",
          disabled: !formValid.value
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`Rechercher `);
            } else {
              return [
                createTextVNode("Rechercher ")
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (__props.advanced) {
        _push(`<div class="w-full grid-cols-3 items-center gap-8 py-12 max-md:px-12 md:px-24 lg:grid">`);
        _push(ssrRenderComponent(_component_form_select, {
          class: "col-span-2 max-lg:mb-5",
          label: "Type de transport",
          options: [
            { value: null, text: "Choisir un type" },
            {
              value: "before_coffin",
              text: "Transport avant et après mise en bière (Frigorifique)"
            },
            {
              value: "after_coffin",
              text: "Transport après mise en bière"
            }
          ]
        }, null, _parent));
        _push(ssrRenderComponent(_component_rounded_button, {
          class: "max-lg:mx-auto max-md:mx-auto max-md:px-12",
          icon: "loupe",
          design: "3",
          type: "submit",
          size: "lg",
          disabled: !formValid.value
        }, {
          default: withCtx((_2, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`Rechercher mon trajet `);
            } else {
              return [
                createTextVNode("Rechercher mon trajet ")
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/SearchForm.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_0 = _sfc_main;
export {
  __nuxt_component_0 as _,
  __nuxt_component_12 as a
};
//# sourceMappingURL=SearchForm-76ddffad.js.map
