import { mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderClass, ssrInterpolate, ssrRenderSlot } from "vue/server-renderer";
import { _ as _export_sfc } from "../server.mjs";
const FormField_vue_vue_type_style_index_0_scoped_a1a90f8a_lang = "";
const _sfc_main = {
  props: {
    required: {
      type: Boolean,
      default: false
    },
    labelClass: {
      type: String,
      default: "text-primary"
    },
    name: {
      type: String,
      required: true
    },
    errors: {
      type: Object,
      default: () => ({})
    },
    label: {
      type: String,
      default: ""
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex flex-col" }, _attrs))} data-v-a1a90f8a>`);
  if ($props.label) {
    _push(`<label class="${ssrRenderClass(`${$props.labelClass} ${$props.errors[$props.name] ? "text-red-500" : ""} mb-3 block font-medium`)}" data-v-a1a90f8a>${ssrInterpolate($props.label)} `);
    if ($props.required) {
      _push(`<span class="required" data-v-a1a90f8a>*</span>`);
    } else {
      _push(`<!---->`);
    }
    ssrRenderSlot(_ctx.$slots, "after-label", {}, null, _push, _parent);
    _push(`</label>`);
  } else {
    _push(`<!---->`);
  }
  ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
  if ($props.errors[$props.name]) {
    _push(`<small class="text-red-500" data-v-a1a90f8a>${ssrInterpolate($props.errors[$props.name][0])}</small>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/FormField.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_5 = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender], ["__scopeId", "data-v-a1a90f8a"]]);
export {
  __nuxt_component_5 as _
};
//# sourceMappingURL=FormField-14acbd69.js.map
