import _ from "lodash";
import { resolveComponent, mergeProps, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate } from "vue/server-renderer";
import { _ as _export_sfc } from "../server.mjs";
const _sfc_main = {
  props: {
    placeholder: {
      type: String,
      default: ""
    },
    modelValue: {
      default: ""
    },
    design: {
      type: Number,
      default: 1
    },
    returnObject: {
      type: Boolean,
      default: false
    }
  },
  watch: {
    modelValue: {
      immediate: true,
      async handler(val) {
        if (val) {
          const city = await this.getCityById(val);
          if (city) {
            this.options = [city];
            this.internalValue = city;
          }
        }
      }
    }
  },
  data() {
    return {
      internalValue: null,
      loading: false,
      options: []
    };
  },
  methods: {
    selectCity(e) {
      var _a;
      if ((_a = e.value) == null ? void 0 : _a.id) {
        this.$emit("update:modelValue", this.returnObject ? e.value : e.value.id);
      }
    },
    searchCities: _.debounce(function(searchQuery) {
      this.loading = true;
      return this.$api.call("get", this.$api.route("cities.index"), null, {
        q: searchQuery.query
      }).then((payload) => {
        this.options = payload;
      }).catch((err) => {
        console.log(err);
      }).finally(() => {
        this.loading = false;
      });
    }, 300),
    getCityById(id) {
      this.loading = true;
      return this.$api.call("get", this.$api.route("cities.show", { city: id })).then((payload) => {
        return payload;
      }).catch((err) => {
        console.log(err);
      }).finally(() => {
        this.loading = false;
      });
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_AutoComplete = resolveComponent("AutoComplete");
  _push(ssrRenderComponent(_component_AutoComplete, mergeProps({
    forceSelection: "",
    placeholder: $props.placeholder,
    modelValue: $data.internalValue,
    "onUpdate:modelValue": ($event) => $data.internalValue = $event,
    optionLabel: (o) => `${o.name} (${o.zip_code})`,
    suggestions: $data.options,
    onComplete: $options.searchCities,
    onChange: $options.selectCity,
    pt: {
      input: { class: "w-full " }
    }
  }, _attrs), {
    option: withCtx((slotProps, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(`${ssrInterpolate(slotProps.option.name)} (${ssrInterpolate(slotProps.option.zip_code)}) `);
      } else {
        return [
          createTextVNode(toDisplayString(slotProps.option.name) + " (" + toDisplayString(slotProps.option.zip_code) + ") ", 1)
        ];
      }
    }),
    _: 1
  }, _parent));
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/form/CitySelectField.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const CitySelectField = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  CitySelectField as C
};
//# sourceMappingURL=CitySelectField-385f4d0e.js.map
