import { _ as __nuxt_component_0, a as __nuxt_component_3 } from "./Price-aaf3d10e.js";
import { _ as __nuxt_component_3$1 } from "./Icon-7157bd57.js";
import { _ as __nuxt_component_8 } from "./RoundedButton-a0ea68b9.js";
import { mergeProps, withCtx, createVNode, createTextVNode, openBlock, createBlock, createCommentVNode, useSSRContext } from "vue";
import "hookable";
import { n as useRouter } from "../server.mjs";
import "destr";
import "devalue";
import "klona";
import { ssrRenderComponent } from "vue/server-renderer";
const _sfc_main = {
  __name: "AvailableRouteCard",
  __ssrInlineRender: true,
  props: {
    route: {
      type: Object,
      required: true,
      default: () => ({})
    },
    hideBooking: {
      type: Boolean,
      default: false
    }
  },
  setup(__props) {
    useRouter();
    return (_ctx, _push, _parent, _attrs) => {
      const _component_base_route_card = __nuxt_component_0;
      const _component_price = __nuxt_component_3;
      const _component_icon = __nuxt_component_3$1;
      const _component_rounded_button = __nuxt_component_8;
      _push(ssrRenderComponent(_component_base_route_card, mergeProps({ route: __props.route }, _attrs), {
        main: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_price, {
              pricing: __props.route.pricing
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_price, {
                pricing: __props.route.pricing
              }, null, 8, ["pricing"])
            ];
          }
        }),
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="text-neutral-lighter flex items-center justify-between gap-5 max-md:flex-col"${_scopeId}><div class="flex flex-col gap-2"${_scopeId}><div class="flex max-md:mb-5"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_icon, {
              icon: "lit",
              class: "text-primary-light mr-3 h-6 w-6"
            }, null, _parent2, _scopeId));
            if (__props.route.vehicle.type === "before_coffin") {
              _push2(`<span${_scopeId}> Transport avant et après mise en bière</span>`);
            } else {
              _push2(`<!---->`);
            }
            if (__props.route.vehicle.type === "after_coffin") {
              _push2(`<span${_scopeId}> Transport après mise en bière</span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div><div class="flex max-md:mb-5"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_icon, {
              icon: "dimensions",
              class: "text-primary-light mr-3 h-6 w-6"
            }, null, _parent2, _scopeId));
            if (__props.route.vehicle.is_standard_size) {
              _push2(`<span${_scopeId}> Supporte des tailles standards uniquement (&lt; ou = à 195cm x 60cm)</span>`);
            } else {
              _push2(`<span${_scopeId}> Supporte des tailles hors normes (&gt; à 195cm x l60cm)</span>`);
            }
            _push2(`</div></div>`);
            if (!__props.hideBooking) {
              _push2(`<div${_scopeId}>`);
              if (__props.route.is_reservation) {
                _push2(ssrRenderComponent(_component_rounded_button, {
                  class: "bg-secondary max-md:px-24",
                  disabled: "",
                  design: "4"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(` EN ATTENTE DE VALIDATION `);
                    } else {
                      return [
                        createTextVNode(" EN ATTENTE DE VALIDATION ")
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              if (__props.route.is_mine) {
                _push2(ssrRenderComponent(_component_rounded_button, {
                  disabled: "",
                  class: "max-md:px-24",
                  design: "4"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(` VOTRE TRAJET `);
                    } else {
                      return [
                        createTextVNode(" VOTRE TRAJET ")
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              if (!__props.route.is_reservation && !__props.route.is_mine) {
                _push2(ssrRenderComponent(_component_rounded_button, {
                  class: "max-md:px-24",
                  design: "3",
                  onClick: ($event) => _ctx.$emit("book", __props.route)
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(` RESERVER `);
                    } else {
                      return [
                        createTextVNode(" RESERVER ")
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "text-neutral-lighter flex items-center justify-between gap-5 max-md:flex-col" }, [
                createVNode("div", { class: "flex flex-col gap-2" }, [
                  createVNode("div", { class: "flex max-md:mb-5" }, [
                    createVNode(_component_icon, {
                      icon: "lit",
                      class: "text-primary-light mr-3 h-6 w-6"
                    }),
                    __props.route.vehicle.type === "before_coffin" ? (openBlock(), createBlock("span", { key: 0 }, " Transport avant et après mise en bière")) : createCommentVNode("", true),
                    __props.route.vehicle.type === "after_coffin" ? (openBlock(), createBlock("span", { key: 1 }, " Transport après mise en bière")) : createCommentVNode("", true)
                  ]),
                  createVNode("div", { class: "flex max-md:mb-5" }, [
                    createVNode(_component_icon, {
                      icon: "dimensions",
                      class: "text-primary-light mr-3 h-6 w-6"
                    }),
                    __props.route.vehicle.is_standard_size ? (openBlock(), createBlock("span", { key: 0 }, " Supporte des tailles standards uniquement (< ou = à 195cm x 60cm)")) : (openBlock(), createBlock("span", { key: 1 }, " Supporte des tailles hors normes (> à 195cm x l60cm)"))
                  ])
                ]),
                !__props.hideBooking ? (openBlock(), createBlock("div", { key: 0 }, [
                  __props.route.is_reservation ? (openBlock(), createBlock(_component_rounded_button, {
                    key: 0,
                    class: "bg-secondary max-md:px-24",
                    disabled: "",
                    design: "4"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(" EN ATTENTE DE VALIDATION ")
                    ]),
                    _: 1
                  })) : createCommentVNode("", true),
                  __props.route.is_mine ? (openBlock(), createBlock(_component_rounded_button, {
                    key: 1,
                    disabled: "",
                    class: "max-md:px-24",
                    design: "4"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(" VOTRE TRAJET ")
                    ]),
                    _: 1
                  })) : createCommentVNode("", true),
                  !__props.route.is_reservation && !__props.route.is_mine ? (openBlock(), createBlock(_component_rounded_button, {
                    key: 2,
                    class: "max-md:px-24",
                    design: "3",
                    onClick: ($event) => _ctx.$emit("book", __props.route)
                  }, {
                    default: withCtx(() => [
                      createTextVNode(" RESERVER ")
                    ]),
                    _: 1
                  }, 8, ["onClick"])) : createCommentVNode("", true)
                ])) : createCommentVNode("", true)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("components/cards/routes/AvailableRouteCard.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_1 = _sfc_main;
export {
  __nuxt_component_1 as _
};
//# sourceMappingURL=AvailableRouteCard-3afeb6c6.js.map
